#include <FeaturePoints.h>
#include <collapseSkel3d.h>
#include <memory>
#include <iostream>
#include <tuple>
#include <vector>

#include <iostream>
#include <fstream>
#include <sstream>

#include <SkeletonModel.h>
#include <surface/Graph.h>
#include <NoiseCreator.h>
#include <TestHelpers.h>
#include <SkeletonReconstructor.h>
#include "Stopwatch.h"

using namespace std;


int TestReconstructionSpeed()
{
	Volume<byte> data;

	if (!data.readVTKField("normalcube.vtk", 10))
	{
		cerr << "Loading bear.vtk failed" << endl;
		return false;
	}
	Volume<byte> original = data;

	collapseSkel3d skel(false, true);
	int borderVoxels;

	cout << "Computing Skeleton...." << endl;
	skel.init(data, 0, borderVoxels, false);
	shared_ptr<SkeletonModel> inputModel(new SkeletonModel(skel, 0.0f));
	surface::Graph graph;
	graph.construct(inputModel->GetThinPoints());

	ofstream logfile("reconstruction_speed_final.csv", ios::out);

	// add noise, then reset skeleton
	NoiseCreator noiseCreator(data, graph, inputModel);
	noiseCreator.GeneratePoints(0.020, NoisePickType::Convex, NoiseShape::Ball, 3.0f);

	skel.reset();
	skel.init(data, 0, borderVoxels, false);
	while (skel.collapse_iteration(1.0f));


	int totalPoints = getForegroundPoints(data);
	int totalSkeletonPoints = getForegroundPoints(skel.getImportance());

	std::vector<float> sortedImportancePoints = CreateImportanceIndex(skel.getImportance(), 10);

	for (float imp : sortedImportancePoints)
	{
		Volume<byte> reconstruction;
		SkeletonModel skeletonModel(skel, imp);
		reconstruction.makeVolume(data.getWidth(), data.getHeight(), data.getDepth());
		auto skelPoints = skeletonModel.GetSkelPoints();
    cout << skelPoints.size() << endl;

		Stopwatch timer;
		
    cout << "Computing slow reconstruction " << std::endl;
    timer.start("reconstruction_slow");
		for (auto& p : skelPoints)
			reconstruction.addSphere(coord3s(p.x, p.y, p.z), 1, skel.getEDT()(p.x, p.y, p.z) - 0.01f);
    timer.stop("reconstruction_slow");

    cout << "Computing fast reconstruction " << std::endl;
    timer.start("reconstruction_fast");
		SkeletonReconstructor reconstructor(skeletonModel.GetSkelPoints(), skel.getEDT());
		reconstructor.Reconstruct(ReconstructionSmoothingType::None, 0);
		timer.stop("reconstruction_fast");

		double timeFast = timer.get_last_time("reconstruction_fast");
    double timeSlow = timer.get_last_time("reconstruction_slow");


		float error = static_cast<float>(volumeDiff(data, reconstruction)) / totalPoints;
		float volumeRatio = static_cast<float>(skelPoints.size()) / totalPoints;

		cout << skelPoints.size() << ", " << timeFast << ", " << timeSlow << std::endl;
		logfile << skelPoints.size() << ", " << timeFast << ", " << timeSlow << std::endl;
	}

  return 0;

}
//
//int main(int argc, char *argv[])
//{
//  return TestReconstructionSpeed();
//}
