// ball-splatting fragment shader


uniform sampler2D sampler;



vec3 float2rgb(float value)					//simple color-coding routine
{
   const float dx = 0.8;
   vec3 col;
   
   if (value<0.0) value=0.0;
   if (value>1.0) value=1.0;
   
   value = (6.0-2.0*dx)*value+dx;
   col.r = max(0.0,(3.0-abs(value-4.0)-abs(value-5.0))/2.0);
   col.g = max(0.0,(4.0-abs(value-2.0)-abs(value-4.0))/2.0);
   col.b = max(0.0,(3.0-abs(value-1.0)-abs(value-2.0))/2.0);
   
   return col;
}


void main()
{	
	vec4 tex = texture2D(sampler, gl_TexCoord[0].xy);

	float z = tex.x + 0.00390625 * tex.y + 0.00001538 * tex.z;		

	vec3 col = (gl_Color.w==0.0)? vec3(1,1,1) : float2rgb(gl_Color.y);

	//outputs
	
	gl_FragColor = vec4(col.r*tex.w, col.g*tex.w, col.b*tex.w, z);

	gl_FragDepth = gl_FragCoord.z - z*gl_Color.x;
}


/*
   vec3 L = normalize(gl_LightSource[0].position.xyz - v);   
   vec3 E = normalize(-v); // we are in Eye Coordinates, so EyePos is (0,0,0)  
   vec3 R = normalize(-reflect(L,N));  
 
   //calculate Ambient Term:  
   vec4 Iamb = gl_FrontLightProduct[0].ambient;    

   //calculate Diffuse Term:  
   vec4 Idiff = gl_FrontLightProduct[0].diffuse * max(dot(N,L), 0.0);
   Idiff = clamp(Idiff, 0.0, 1.0);     
   
   // calculate Specular Term:
   vec4 Ispec = gl_FrontLightProduct[0].specular 
                * pow(max(dot(R,E),0.0),0.3*gl_FrontMaterial.shininess);
   Ispec = clamp(Ispec, 0.0, 1.0); 
*/

