#version 120 
#extension GL_ARB_geometry_shader4 : enable

// Z-color component is scaled with the max ball radius to get the real scale.
uniform float ballMaxScale;

// ball-splatting geom. shader
void main(void)
{
    //Ball radius is now normalized between [0,1] and recovered using ballMaxScale
    float r = gl_FrontColorIn[0].z * ballMaxScale;

    //get one point as input
    //generate one triangle strip (made of two triangles) representing one quad

    gl_Position = gl_PositionIn[0]; //eye-space position
    gl_Position.x -= r;
    gl_Position.y -= r;
    gl_Position = gl_ProjectionMatrix * gl_Position;
    gl_TexCoord[0].xy = vec2(0, 0);
    gl_FrontColor = gl_FrontColorIn[0];
    EmitVertex();

    gl_Position = gl_PositionIn[0];
    gl_Position.x -= r;
    gl_Position.y += r;
    gl_Position = gl_ProjectionMatrix * gl_Position;
    gl_TexCoord[0].xy = vec2(0, 1);
    gl_FrontColor = gl_FrontColorIn[0];
    EmitVertex();

    gl_Position = gl_PositionIn[0];
    gl_Position.x += r;
    gl_Position.y -= r;
    gl_Position = gl_ProjectionMatrix * gl_Position;
    gl_TexCoord[0].xy = vec2(1, 0);
    gl_FrontColor = gl_FrontColorIn[0];
    EmitVertex();

    gl_Position = gl_PositionIn[0];
    gl_Position.x += r;
    gl_Position.y += r;
    gl_Position = gl_ProjectionMatrix * gl_Position;
    gl_TexCoord[0].xy = vec2(1, 1);
    gl_FrontColor = gl_FrontColorIn[0];
    EmitVertex();		

    EndPrimitive();	
		
}

