// ball-splatting vertex shader

// Z-color component is scaled with the max ball radius to get the real scale.
uniform float ballMaxScale;

void main()
{	
	//map vertices to eye space so that geom. shader picks them from there	      
	gl_Position = gl_ModelViewMatrix * gl_Vertex; 
	
	//encode rNDC as x-color component
	//LUK: no idea anymore where it comes from...
		
	float NDC_factor = 0.5*gl_ProjectionMatrix[3][2]/gl_ProjectionMatrix[2][3];
	float radius = gl_Color.z * ballMaxScale;
	float rNDC = NDC_factor*radius/gl_Position.z/(radius+gl_Position.z);

	gl_FrontColor = vec4(rNDC, gl_Color.yzw);  
}
