#version 330
#extension GL_ARB_shading_language_420pack : require

layout(binding = 0, std140) uniform ShaderData
{
    mat4 modelViewProj;
    mat4 modelView;
    mat4 inverseModelView;

    float projectScale;
    float near;
    vec2 unprojectScale;
    vec2 unprojectOffset;
    float depthScale;
    float depthOffset;

    vec3 lightPosition;
    float shininess;
    float specularCoeff;
    float diffuseCoeff;
    float ambientCoeff;

    float splatScale;
    float holeFillingFilterRadius;

    float minRoiWeight;
    float maxRoiWeight;
    bool visualizeRoiWeights;
    bool backfaceCulling;
};

layout(binding = 0) uniform sampler2D colorWeightSampler;
layout(binding = 1) uniform sampler2D normalLambdaSampler;

in vec2 texCoords;
out vec3 position;

void main()
{
    float weight = texture(colorWeightSampler, texCoords).a;
    float lambda = texture(normalLambdaSampler, texCoords).a / weight;
    
    if (lambda < 1.0E-6)
        discard;

    vec3 qn = vec3(gl_FragCoord.xy * unprojectScale - unprojectOffset, -near);
    vec3 q = lambda * qn;

    position = vec3(inverseModelView * vec4(q, 1.0));
}
