#version 330
#extension GL_ARB_shading_language_420pack : require

#define RAINBOW_MAP 1

layout(binding = 0, std140) uniform ShaderData
{
    mat4 modelViewProj;
    mat4 modelView;
    mat4 inverseModelView;

    float projectScale;
    float near;
    vec2 unprojectScale;
    vec2 unprojectOffset;
    float depthScale;
    float depthOffset;

    vec3 lightPosition;
    float shininess;
    float specularCoeff;
    float diffuseCoeff;
    float ambientCoeff;

    float splatScale;
    float holeFillingFilterRadius;

    float minRoiWeight;
    float maxRoiWeight;
    bool visualizeRoiWeights;
    bool backfaceCulling;
};

uniform float depthEpsilon;

in VertexData
{
    vec3 uCrossV;
    vec3 pCrossMinV;
    vec3 minUCrossP;
    float pDotUCrossV;

    vec3 color;
    vec3 normal;
    float radius;
    float roiWeight;
    float cullWeight;
} inData;

layout(location = 0) out vec4 colorWeight;
layout(location = 1) out vec4 normalLambda;

vec3 mapRoiWeight()
{
    float value = (inData.roiWeight - minRoiWeight) / (maxRoiWeight - minRoiWeight);
#if RAINBOW_MAP
    const float dx = 0.8;
    float scaled = (6 - 2 * dx) * value + dx;
    float r = max(0.0, (3.0 - abs(scaled - 4.0) - abs(scaled - 5.0)) / 2.0);
    float g = max(0.0, (4.0 - abs(scaled - 2.0) - abs(scaled - 4.0)) / 2.0);
    float b = max(0.0, (3.0 - abs(scaled - 1.0) - abs(scaled - 2.0)) / 2.0);
    return vec3(r, g, b);
#else // Gray map
    // Add a little so there's no black.
    return 0.1 + 0.9 * vec3(value);
#endif
}

void main()
{
    vec3 q = vec3(gl_FragCoord.xy * unprojectScale - unprojectOffset, -near);

    float qDotUCrossV = dot(q, inData.uCrossV);
    float u = dot(q, inData.pCrossMinV) / qDotUCrossV;
    float v = dot(q, inData.minUCrossP) / qDotUCrossV;

    float dist = sqrt(u*u + v*v);
    if (dist > 1.0) discard;

    float lambda = abs(inData.pDotUCrossV / qDotUCrossV);
    gl_FragDepth = depthScale / (lambda * q.z - depthEpsilon * inData.radius) + depthOffset;

    float weight = smoothstep(0.01, 1.0, 1.0 - dist) * inData.cullWeight;

    if (weight < 1.0E-5)
        discard;

    colorWeight = weight * vec4(
        visualizeRoiWeights ? mapRoiWeight() : inData.color,
        1.0);
    normalLambda = weight * vec4(inData.normal, lambda);
};
