#version 330
#extension GL_ARB_shading_language_420pack : require

layout(binding = 0, std140) uniform ShaderData
{
    mat4 modelViewProj;
    mat4 modelView;
    mat4 inverseModelView;

    float projectScale;
    float near;
    vec2 unprojectScale;
    vec2 unprojectOffset;
    float depthScale;
    float depthOffset;

    vec3 lightPosition;
    float shininess;
    float specularCoeff;
    float diffuseCoeff;
    float ambientCoeff;

    float splatScale;
    float holeFillingFilterRadius;
    
    float minRoiWeight;
    float maxRoiWeight;
    bool visualizeRoiWeights;
    bool backfaceCulling;
};

layout(location = 0) in vec3 position;
layout(location = 1) in vec3 color;
layout(location = 2) in vec3 u;
layout(location = 3) in vec3 v;
layout(location = 4) in float roiWeight;

out VertexData
{
    vec3 uCrossV;
    vec3 pCrossMinV;
    vec3 minUCrossP;
    float pDotUCrossV;

    vec3 color;
    vec3 normal;
    float radius;
    float roiWeight;
    float cullWeight;
} outData;

void main()
{
    gl_Position = modelViewProj * vec4(position, 1.0);

    vec3 us = u;
    vec3 vs = v;

    // If no normal is found the splat is view-alligned
    bool isViewAligned = dot(u,u) < 1.0e-5;
    if(isViewAligned)
    {
        us = normalize(vec3(modelView[0][0], modelView[1][0], modelView[2][0]));
        vs = normalize(vec3(modelView[0][1], modelView[1][1], modelView[2][1]));
    }

    vec3 pView = (modelView * vec4(position, 1.0)).xyz;
    vec3 uView = (modelView * vec4(splatScale * us, 0.0)).xyz;
    vec3 vView = (modelView * vec4(splatScale * vs, 0.0)).xyz;

    outData.uCrossV = cross(uView, vView);
    outData.pDotUCrossV = dot(pView, outData.uCrossV);

    outData.pCrossMinV = cross(pView, -vView);
    outData.minUCrossP = cross(-uView, pView);

    outData.color = color;
    outData.normal = normalize(outData.uCrossV);

    outData.radius = sqrt(max(dot(uView, uView), dot(vView, vView)));
    gl_PointSize = outData.radius * projectScale / pView.z;

    outData.roiWeight = roiWeight;
    outData.cullWeight = outData.pDotUCrossV > 0.0 || isViewAligned?
        (backfaceCulling? 0.0f : 0.001f) : 1.0f;
}
