#pragma once
#include "FeaturePoints.h"
#include "SkeletonModel.h"
#include "NoiseCreator.h"
#include "skelrender.h"
#include <memory>


class Renderer;

class AddNoisePickHandler
{
  Volume<float> &importance;
  Volume<float> &edt;
  Volume<byte>  &thinImage;
  const int width, height, depth;
  const coord3s bounds;

  FeaturePoints& featurePoints;
  std::shared_ptr<SkeletonModel> inputModel;
  std::shared_ptr<SkeletonModel> skeletonModel;
  collapseSkel3d& skel;

  short radius = 2;
  short noiseHeight = 4;
  short noiseLength = 3;
  NoiseShape shape = NoiseShape::Ball;
  NoisePickType pickType = NoisePickType::Convex;

  surface::Graph& graph;
  NoiseCreator noiseCreator;
  Renderer& renderer;

public:
  AddNoisePickHandler(FeaturePoints& featurePoints, std::shared_ptr<SkeletonModel> inputModel, 
    std::shared_ptr<SkeletonModel> skeletonModel, surface::Graph& graph, collapseSkel3d& skel,
    Renderer& renderer);

  void OnPick(double x, double y, double z, bool picked_something);
  void generatePoints(double probability);

  short getRadius() const;
  void setRadius(short value);
  short getLength() const;
  void setLength(short value);
  NoiseShape getShape() const;
  void setShape(const NoiseShape &value);
  NoisePickType getPickType() const;
  void setPickType(const NoisePickType &value);
  void setNoiseHeight(short height);
};
