#pragma once
#include "MainWindow.h"
#include "GlutWindow.h"
#include "skelrender.h"
#include "SkeletonController.h"
#include "AddNoisePickHandler.h"
#include "VolumeOpenController.h"

#include <QApplication>
#include <memory>
#include <thread>



class Application
{
  int argc; char **argv;

  QApplication qtApp;
  GlutWindow& glutWindow;
  VolumeOpenController volumeOpenController;
  MainWindow mainWindow;
  std::thread glutThread;
  Renderer* ren;

  std::unique_ptr<collapseSkel3d> skel;
  std::shared_ptr<SkeletonController> skeletonController;


  float maxDepth;

  double     timer;
  double     execTime;
  int        iterations = 0;
  int        foreground = 0;
  int        bordervoxels = 0;



public:
  Application(int argc, char *argv[]);
  bool ParseCmdArgs();
  void InitializeGlutWindow();
  bool OpenVolumeExternal(std::string filename, int threshold = 0, int pad = 10);
  bool OpenVolume(std::string filename, int threshold = 0, int pad = 10);

  int Execute();

private:
  bool InitFromCmd();
};
