#pragma once
#include "skelrender.h"
#include "collapseSkel3d.h"
#include "zpr.h"
#include "TaskScheduler.h"
#include "SkeletonController.h"
#include "AddNoisePickHandler.h"

#include <memory>
#include <mutex>

enum class PickType
{
  AddNoise,
  Info,
  CorridorGraph
};



// GlutWindow is a singleton to work around the staticness of GLUT
class GlutWindow
{
public:
  GlutWindow();
  virtual ~GlutWindow();

  // Singleton stuff
  static GlutWindow& GetInstance();
  // Forbid copying a singleton
  GlutWindow(const GlutWindow& src) = delete;
  GlutWindow& operator=(const GlutWindow& rhs) = delete;

  void MainLoop();
  void Initialize(collapseSkel3d* skel);
  void SetSkeletonController(SkeletonController* skeletonController);
  void AddTask(Task task);
  void Close();
  void Refresh();


  // Getters and Setters
  Renderer* getRen() const;

  float getMaxDepth() const;
  void setMaxDepth(float value);

  int getInputDrawStyle() const;
  void setInputDrawStyle(int value);

  int getSkeletonDrawStyle() const;
  void setSkeletonDrawStyle(int value);

  int getBoundaryDrawStyle() const;
  void setBoundaryDrawStyle(int value);

  int getSelectionFeaturePoints() const;
  void setSelectionFeaturePoints(int value);

  bool getShowStatistics() const;
  void setShowStatistics(bool value);

  bool IsClosed() const { return isClosed; }

  PickType getPickMode() const;
  void setPickMode(const PickType &value);



private:
  static std::unique_ptr<GlutWindow> instance;
  static std::once_flag onceFlag;

  std::unique_ptr<Renderer> ren;
  TaskScheduler scheduler;
  SkeletonController* skeletonController;
  float maxDepth = 3000;
  int inputDrawStyle = DRAW_ISOSURFACE;
  int skeletonDrawStyle = DRAW_POINTS;
  int boundaryDrawStyle = DRAW_NOTHING;
  bool showStatistics = false;
  bool isClosed = true;
  PickType pickMode = PickType::AddNoise;


// Fields copied from main
  const float geo_front_eps = 1.0f;
  int win_id;
  int win_x = 800, win_y = 600;
  int mouse_down[16];

  collapseSkel3d*  skel;
  const float imp_step = 0.3e-5f; //importance increment (for incrementing the threshold tau)
  int buttons[256];
  int           selectionFeaturePoints = 0;
  int           bordervoxels = 0;


// Glut Handlers
  void glutKeyboardFuncHandler(unsigned char key, int x, int y);
  void glutMouseFuncHandler(int button, int state, int x, int y);
  void glutMotionFuncHandler(int x, int y);
  void glutReshapeFuncHandler(int width, int height);
  void glutDisplayFuncHandler();
  void glutIdleFuncHandler();
  void showInfoHandler(double x, double y, double z, bool picked_something);
  void showCorridorGraphHandler(double x, double y, double z, bool picked_something);
  void addNoisePickHandler(double x, double y, double z, bool picked_something);
  void zprPickFuncHandler(double x, double y, double z, bool picked_something);


// Static GLUT wrappers which calls the handlers on this singleton
  static void glutKeyboardFuncWrapper(unsigned char key, int x, int y);
  static void glutMouseFuncWrapper(int button, int state, int x, int y);
  static void glutMotionFuncWrapper(int x, int y);
  static void glutReshapeFuncWrapper(int width, int height);
  static void glutDisplayFuncWrapper();
  static void glutIdleFuncWrapper();
  static void zprPickFuncWrapper(double x, double y, double z, bool picked_something);

  void preDisplay();
  void postDisplay();
  void InitGlut();
};
