#pragma once

#include <Eigen/Dense>
#include <glm/vec2.hpp>
#include <glm/vec3.hpp>
#include <glm/vec4.hpp>
#include "Point3d.h"

typedef Eigen::Matrix<float, 9, 1> Vector9f;
typedef Eigen::Matrix<double, 9, 1> Vector9d;

struct PVector9
{
  Vector9f px;
  float roiWeight;

  PVector9() {}
  PVector9(const Vector9f& px, const float roiWeight) :
    px(px), roiWeight(roiWeight)
  {}
};

Eigen::Vector2f VecConvert(const glm::vec2& vec);
Eigen::Vector3f VecConvert(const glm::vec3& vec);
Eigen::Vector4f VecConvert(const glm::vec4& vec);

glm::vec2 VecConvert(const Eigen::Vector2f& vec);
glm::vec3 VecConvert(const Eigen::Vector3f& vec);
glm::vec4 VecConvert(const Eigen::Vector4f& vec);

glm::vec3 VecConvert(const Point3d vec);

