#pragma once
#include <string>
#include <mutex>
#include <QObject>
#include <memory>
#include "surface/Graph.h"
#include "surface/PlaneTrace.h"


class Renderer;
class SkeletonController;


///provides graphical information about a skeleton point and its feature points
class ShowCorridorGraphHandler : public QObject
{
  Q_OBJECT
  std::mutex d_mtx;
  SkeletonController &r_skeletonController;
  bool d_sp_selected;
  size_t d_sp_idx;
  std::unique_ptr<surface::Graph> up_cutband;
signals:
  void pickChanged();
public:
  ShowCorridorGraphHandler(SkeletonController &skeletonController);
  void onPick(double x, double y, double z, bool picked_something);
  void draw(Renderer &ren);
private:
  void drawCorridorGraph(Renderer &ren);
};
