#pragma once
#include <string>
#include <mutex>
#include <QObject>
#include <surface/AStar.h>
#include <memory>


class Renderer;
class SkeletonController;
class CutSetRenderer;

///provides graphical information about a skeleton point and its feature points
class ShowInfoHandler : public QObject
{
  Q_OBJECT
  std::mutex d_mtx;
  SkeletonController &r_skeletonController;
  std::unique_ptr<CutSetRenderer> up_cutSetRenderer;
  bool d_sp_selected;
  size_t d_sp_idx;
  bool d_enableCut;
  bool d_enableCutSet;
  bool d_enableFeaturePoints;
  bool d_enableArrow;
  bool d_enableStreamlines;
  Point3d d_selectedPoint;
signals:
  void pickChanged();
  void enableCutChanged(bool value);
  void enableCutSetChanged(bool value);
  void enableFeaturePointsChanged(bool value);
public:
  ShowInfoHandler(SkeletonController &skeletonController);
  ~ShowInfoHandler();
  void onPick(double x, double y, double z, bool picked_something);
  void draw(Renderer &ren);
  void drawEdtArrow(Renderer &ren);
  std::string getInfoString();

  void setEnableCut(bool value);
  bool getEnableCut() const {return d_enableCut;}

  void setEnableCutSet(bool value);
  bool getEnableCutSet() const {return d_enableCut;}

  void setEnableFeaturePoints(bool value);
  bool getEnableFeaturePoints() const {return d_enableFeaturePoints;}

  void setEnableStreamlines(bool value);
  bool getEnableStreamlines() const { return d_enableStreamlines; }
private:
  void drawCut(Renderer &ren);
  float geoDistbetweenFeaturePoints(size_t index);
  float euclDistbetweenFeaturePoints(size_t index);
  float getImportance(size_t index);
  float getEDT(size_t index);
  float getSaliency(size_t index);
};
