#pragma once

#include "collapseSkel3d.h"
#include "surface/Graph.h"
#include "skelrender.h"
#include "SkeletonModel.h"
#include "FeaturePoints.h"
#include "AddNoisePickHandler.h"
#include "ShowCorridorGraphHandler.h"
#include "ShowInfoHandler.h"
#include "SaliencyMetricEngine.h"
#include "ImportanceVolume.h"
#include "SegmentationHandler.h"
#include "cuts/CutController.h"
#include "SkeletonCreationOptions.h"
#include "CutSetRenderer.h"

#include <memory>




class SkeletonController
{
  collapseSkel3d& skel;
  float impThreshold;

  std::shared_ptr<SkeletonModel> skeletonModel;
  std::shared_ptr<SkeletonModel> inputModel;
  std::shared_ptr<SkeletonModel> reconstructionModel;
  std::unique_ptr<FeaturePoints> featurePoints;
  std::shared_ptr<AddNoisePickHandler> noisePickHandler;
  std::shared_ptr<ShowInfoHandler> showInfoHandler;
  std::shared_ptr<ShowCorridorGraphHandler> showCorridorGraphHandler;
  surface::Graph graph;
  Renderer& renderer;
  SaliencyMetricEngine saliencyMetricEngine;

  std::shared_ptr<Volume<float>> saliencyMetricVolume;
  std::unique_ptr<cuts::CutController> cutController;
  std::unique_ptr<SegmentationHandler> segmentationHandler;

  double startTime = 0;
  double execTime = 0;
  int iterations = 0;
  int bordervoxels = 0;
  bool collapseActive = false;
  bool skeletonComputed = false;
  bool visualizeSkeleton = false;
  SkeletonImportanceType importanceType = SkeletonImportanceType::TPAMI;
  SkeletonExtractionMethod extractionMethod = SkeletonExtractionMethod::TPAMI;
  SaliencyMethod saliencyMethod = SaliencyMethod::GlobalImportance;
  ScalarFieldType viewScalarFieldType = ScalarFieldType::Importance;

  std::unique_ptr<ImportanceVolume> importanceVolume;
  std::unique_ptr<ImportanceVolume> saliencyVolume;
  std::unique_ptr<ImportanceVolume> edtVolume;

  Volume<byte> lastInputVolume;
  Volume<byte> lastReconVolume;

public:
  SkeletonController(collapseSkel3d& skel, float impThreshold, Renderer& renderer);

  void StartCollapse(bool visualize = false);
  void StopCollapse();
  void PostSkeletonProcessing();
  void DoCollapseStep();
  void ComputeSkeleton();
  void ResetSkelEngine(const SkeletonCreationOptions& options);
  void ResetSkelEngine(Volume<byte>& volume, bool smoothing = false, bool importanceBoosting = false);
  void Reconstruct(ReconstructionSmoothingType smoothingType, int radius);
  void UpdateImportance(float impThreshold);
  void ComputeSaliency();
  void UpdateSaliency(float threshold, bool onlyKeepLargestComponent);



  bool Update();

  // Getters
  surface::Graph &GetGraph();
  collapseSkel3d &GetSkel() const;
  Renderer &GetRenderer() const;
  std::shared_ptr<SkeletonModel> GetSkeletonModel() const;
  std::shared_ptr<SkeletonModel> GetInputModel() const;
  std::shared_ptr<SkeletonModel> GetReconstructionModel() const;
  FeaturePoints& GetFeaturePoints();
  std::shared_ptr<AddNoisePickHandler> GetNoisePickHandler() const;
  ImportanceVolume* GetSaliencyVolume() const;
  void SetNoisePickHandler(const std::shared_ptr<AddNoisePickHandler> &value);
  float GetEqualizedImportance(float normThreshold);
  bool ImportImportanceVolume(Volume<float>& newImportance);

  std::shared_ptr<ShowInfoHandler> getShowInfoHandler() const;
  void setShowInfoHandler(const std::shared_ptr<ShowInfoHandler> &value);

  std::shared_ptr<ShowCorridorGraphHandler> getShowCorridorGraphHandler() const;
  void setShowCorridorGraphHandler(const std::shared_ptr<ShowCorridorGraphHandler> &value);

  cuts::CutController &getCutController();
  void setCutController(std::unique_ptr<cuts::CutController> value);

  SegmentationHandler &getSegmentationHandler();
  void setSegmentationHandler(std::unique_ptr<SegmentationHandler> value);

  SaliencyMetricEngine& GetSaliencyMetricEngine();
  float GetImpThreshold();

  bool IsDone();
  void SetSaliencyMethod(SaliencyMethod value);
  bool SetScalarField(ScalarFieldType field);

  Volume<byte>& GetVisibleVolume();
  Volume<float>* GetVisibleImportance();
};
