#include <type_traits>

enum class SkeletonCreationFlags : int
{
  None = 0x00,
  GeodesicImportance = 0x01,
  ImportanceBoosting = 0x02,
  VisualizeCreation = 0x04,
  SmoothEdt = 0x08,
  EnableFpReflection = 0x10,
};


enum class SkeletonImportanceType
{
  TPAMI,
  Geodesic,
  GeodesicEstimate,
  ImplicitEuclidean
};

enum class SkeletonExtractionMethod
{
  TPAMI,
  IMA,
  ImplicitEuclidean
};


namespace 
{
  using T = std::underlying_type < SkeletonCreationFlags >  :: type;

  inline SkeletonCreationFlags operator | (SkeletonCreationFlags lhs, SkeletonCreationFlags rhs)
  {
    return (SkeletonCreationFlags)(static_cast<T>(lhs) | static_cast<T>(rhs));
  }

  inline SkeletonCreationFlags operator & (SkeletonCreationFlags lhs, SkeletonCreationFlags rhs)
  {
    return (SkeletonCreationFlags)(static_cast<T>(lhs) & static_cast<T>(rhs));
  }

  inline SkeletonCreationFlags& operator |= (SkeletonCreationFlags& lhs, SkeletonCreationFlags rhs)
  {
    lhs = (SkeletonCreationFlags)(static_cast<T>(lhs) | static_cast<T>(rhs));
    return lhs;
  }

  inline SkeletonCreationFlags& operator &= (SkeletonCreationFlags& lhs, SkeletonCreationFlags rhs)
  {
    lhs = (SkeletonCreationFlags)(static_cast<T>(lhs) & static_cast<T>(rhs));
    return lhs;
  }
}


class SkeletonCreationOptions
{
public:
  SkeletonImportanceType importanceType;
  SkeletonExtractionMethod extractionMethod;
  SkeletonCreationFlags flags;

  SkeletonCreationOptions(SkeletonCreationFlags flags = SkeletonCreationFlags::None, 
    SkeletonImportanceType importanceType = SkeletonImportanceType::TPAMI,
    SkeletonExtractionMethod extractionMethod = SkeletonExtractionMethod::ImplicitEuclidean)
    : importanceType(importanceType), extractionMethod(extractionMethod), flags(flags)
  {
  }
};
