#pragma once

#include "Helpers.h"
#include "Point3d.h"
#include "Volume.h"

#include <string>
#include <vector>
#include <glm/glm.hpp>
#include <glm/gtc/random.hpp>

struct Surfel
{
  glm::vec3 Position;
  glm::vec3 Color;
  glm::vec3 U;
  glm::vec3 V;
};

#pragma pack(push)
#pragma pack(1)

struct Point
{
  glm::vec3 Position;
  glm::vec3 Color;
  glm::vec3 Normal;
};

#pragma pack(pop)

Surfel ComputeCircularSurfel(const Point &point, float scale);
std::vector<Surfel> CreateSurfelList(std::vector<Point3d>& points, std::vector<Point3d>& normals,
  Point3d defaultColor, Volume<float>* scalars, float min, float max);