#pragma once
#include <functional>
#include <queue>
#include <thread>
#include <mutex>

typedef std::function<void()> Task;


// Allows tasks to be added and executed in a different context. Is thread-safe
class TaskScheduler
{
  // We cannot use a lockless queue as std::function has a nontrivial destructor
  std::queue<Task> queue;
  std::mutex mutex;

public:
  TaskScheduler();
  ~TaskScheduler();

  void AddTask(Task task);
  void ConsumeCurrentTasks();

};

