#pragma once

#include "SkeletonController.h"
#include "Volume.h"
#include "GlutWindow.h"
#include "skelrender.h"

#include <memory>
#include <VolumeHelpers.h>
#include <iostream>


class VolumeOpenController
{
  std::shared_ptr<SkeletonController> skeletonController;
  bool firstOpen = true;

  GlutWindow* glutWindow;


public:
  VolumeOpenController(GlutWindow& glutWindow) :
    glutWindow(&glutWindow)
  {
  }

  bool OpenVolumeExternal(collapseSkel3d* skel, Renderer* renderer, std::string filename, int threshold, int pad, int& foreground, float& maxDepth, int& bordervoxels)
  {
    Volume<byte> data;

    bool ok;
    if (strstr(filename.c_str(), ".fld"))
      ok = data.readAVSField(filename.c_str(), pad);
    else if (strstr(filename.c_str(), ".vtk"))
      ok = data.readVTKField(filename.c_str(), pad);
    else if (strstr(filename.c_str(), ".dat"))
    {
      int np = 0;
      int *points(nullptr);
      float *normals(nullptr);
      ok = data.readBinaryField(filename.c_str(), pad, np, points, normals);
      delete[] points;
      delete[] normals;
    }
    else
    {
      printf("Unknown file format.\n");
      return false;
    }
    if (!ok)
    {
      std::cout << "Cannot open " << filename << std::endl;
      return false;
    }

    std::cout << "Extracting largest component....";
    FilterLargestComponent(data);
    std::cout << " done" << std::endl;

    int wd = data.getWidth(), ht = data.getHeight(), dt = data.getDepth();
    maxDepth = 1.5 * sqrt(wd * wd + ht * ht + dt * dt);
    glutWindow->setMaxDepth(maxDepth);

    if (!skeletonController)
    {
      foreground = skel->init(data, threshold, bordervoxels);
      skeletonController.reset(new SkeletonController(*skel, 0.000001f, *renderer));
    }
    else
    {
      skeletonController->ResetSkelEngine(data);
    }

    // todo: find out what these magic constants mean
    zprInit(0, 0, -(1.7f - 0.5f)*dt);


    glutWindow->SetSkeletonController(skeletonController.get());

    renderer->setModels(skeletonController->GetSkeletonModel(), skeletonController->GetInputModel());
    renderer->setFeaturePoints(&skeletonController->GetFeaturePoints());
    renderer->reconstructionModel = std::shared_ptr<SkeletonModel>();

    return true;
  }

  std::shared_ptr<SkeletonController> getSkeletonController()
  {
    return skeletonController;
  }

};
