#pragma once

#include "glwrapper.h"
#include "Point3d.h"
#include "Volume.h"
#include <vector>
#include <memory>
#include <SkeletonModel.h>
#include "SkeletonPointRenderer.h"


class collapseSkel3d;
class FeaturePoints;
class Cut;
class ImportanceVolume;

enum DRAW_STYLE
{
  DRAW_CUBES = 0,
  DRAW_POINTS,
  DRAW_BALLS,
  DRAW_FIXED_BALLS,
  DRAW_ISOSURFACE,
  DRAW_GRAPH,
  DRAW_NOTHING
};

enum class ScalarFieldType
{
  Importance,
  Saliency,
  EDT
};


class Renderer
{
public:

  enum BALL_MODE        //Style of ball reconstruction:
  {
    BALL_GEOM = 0,     //-use geometric spheres (slow,inaccurate)
    BALL_QUAD,       //-use quad billboards
    BALL_SPRITE        //-use shaders
  };

  Renderer(collapseSkel3d &, float imp_thr);
  ~Renderer();
  void          initGL();
  void          drawInputCubes();
  void          drawInputSplats();
  void          drawSurface();
  void          drawBalls();                    //for skeleton only
  void          drawFixedBalls();                 //
  void          drawCubes();
  void          drawSplats();
  void          drawThinCubes();
  void          drawDensity();
  void          drawThinSplats();
  void          drawThinBalls();
  void          drawBoundaryCubes();
  void          drawBoundarySplats();
  void          drawBoundaryFixedBalls();
  void          drawArrow(Point3d point, Vector direction, float len);
  void          drawArrow(Point3d point, float len);
  void          drawVelocity(int step, float len);
  void          drawThinGrad(int step, float len);
  void          drawFeaturePoints(int skelpoint);
  void          drawProjectedSkelBoundary();
  void          drawLog();
  void          drawStreamline(std::vector<coord3s>& points);
  void          setModels(std::shared_ptr<SkeletonModel> skeletonModel, std::shared_ptr<SkeletonModel> inputModel);
  void          setScalar(Volume<float>* scalars, float scalarMin, float scalarMax);
  void          setScalar(ImportanceVolume& importanceVolume);
  void          setFeaturePoints(FeaturePoints* featurePoints);
  void          resizeWindow(int width, int height);


  float         light_diffuse;
  float         light_specular;
  float         specular_power;
  float         light_pos[4];
  int           sphere_faces;                 //resolution of the GLUT spheres
  int
  use_mipmaps;                  //use texture mipmaps for splatting or not
  float
  ball_size;                    //ball size (in obj normalized coords) for the constant-radius ball drawing
  int
  smooth_shading;                 //use vertex normals (if we have them) when we render meshes
  int
  use_floating_textures;              //whether to use floating-point or 24-bit-fixed-point ones for the ball height
  float         bk_col[3];                    //background color
  BALL_MODE ball_mode;                    //how to draw the ball-reconstruction
  float
  vis_imp_min;                  //range of importance (above minimal one) to be mapped
  float         vis_imp_max;                  //to the colormap
  float         imp_min, imp_max;               //absolute range of importance
  float         imp_alpha_min, imp_alpha_slope;
  float         ball_dt_offset;
  float         splat_dt_offset;
  float
  imp_thr;                    //minimal importance (to visualize skel points)
  float         surf_alpha;                   //alpha of polygonal isosurface
  Volume<float>* scalars = nullptr;
  float scalarMin;
  float scalarMax;
  //!!private:

  void          SetUniformBallScale(float scale);
  // make all splat textures using some sampling mode
  void          makeTextures(int sampling_mode = -1);
  void          createSplatFloat(int size, GLfloat* img, int level);
  void          createSplatRGBA(int size, GLubyte* img, int level);
  void          createDisk(int size);
  int           getScalingMode() const;             //return texture scaling mode depending on usage of mipmaps, etc
  void          draw_balls(const std::vector<Point3d> &points, bool use_colormap,
                           bool use_constant_radius, const Volume<float>* scalars = 0);
  void          draw_cubes(const std::vector<Point3d> &points,
                           const Volume<float>* scalars = 0);
  void          draw_splats(const std::vector<Point3d> &points,
                            const std::vector<Point3d> &normals, const Volume<float>* scalars = 0);

  std::shared_ptr<SkeletonModel> skeletonModel; // model containing the thin points and the normals of the skeleton
  std::shared_ptr<SkeletonModel> inputModel; //model containting the thin points of the input
  std::shared_ptr<SkeletonModel> reconstructionModel; //model containting the thin points of the reconstruction

  std::unique_ptr<SkeletonPointRenderer> pointRenderer;

  bool updateRequired = false;
  bool drawReconstruction = false;

  GLuint balltex[2];         //texture IDs for the ball splat (fixed-point and floating-point modes)
  GLuint        splat_quad;         //display list ID for the splat
  GLuint        ball_shader[5];       //shader IDs for the splat fragments
  GLuint        ball_prog;          //shader program ID
  int         splat_size;         //size (pow 2) of the splat texture
  int         scaling_mode;       //internal texmapping param for splats
  collapseSkel3d   &skel;
  GLUquadric*     quad;
  FeaturePoints* featurePoints;        //feature points and related search structures for the full skeleton
 
};






