#ifndef ZPR_H
#define ZPR_H

/*
 * Zoom-pan-rotate mouse manipulation module for GLUT
 * Version 0.4, October 2003
 *
 * Nigel Stewart
 * School of Computer Science and Information Technology
 * RMIT University
 * nigels@cs.rmit.edu.au
 *
 * Instructions
 * ------------
 *
 * Call zprInit() immediately after your call to glutCreateWindow()
 *
 * The ZPR module handles glutReshapeFunc(), glutMouseFunc() and glutMotionFunc()
 * Applications should not bypass the ZPR handlers for reshape or mouse events.
 *
 * Mouse manipulation of the GLUT window via the modelview matrix:
 *
 * Left   button -> rotate
 * Middle button -> zoom
 * Right  button -> pan
 *
 * Picking is also provided:
 *
 * void zprPickFunc(void (*f)(double,double,double,bool))
 *
 *   The callback function receives the coordinate of the picked point and true, if something was picked;
 *   else it receives unspecified coordinates and false.
 *
 * Limitations
 * -----------
 *
 * Works best with zprReferencePoint appropriately configured.
 * Works best with ortho projection.
 * You may need to use glEnable(GL_NORMALIZATION) for correct lighting.
 * Near and far clip planes are hard-coded.
 * Zooming and rotation is centered on the origin.
 * Only one window can use the callbacks at one time.
 *
 */

#include "glwrapper.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
 *
 */

/* Mouse Manipulation API */

void zprInit(float cx, float cy, float cz);

void zprMouse(int button, int state, int x, int y);

void zprMotion(int x, int y);

void zprPostDraw();

extern GLfloat zprReferencePoint[4];

/* Picking API (Optional) */

extern void zprPickFunc(void (*f)(GLdouble, GLdouble, GLdouble,
                                  bool picked_something));  /* Pick event handling function */

/*
 *
 */

#ifdef __cplusplus
}
#endif

#endif
