#include "AddNoisePickHandler.h"

#include <PointSearch.h>
#include <iostream>
#include <algorithm>
#include <random>
using namespace std;




short AddNoisePickHandler::getRadius() const
{
  return radius;
}

void AddNoisePickHandler::setRadius(short value)
{
  radius = value;
}

short AddNoisePickHandler::getLength() const
{
  return noiseLength;
}

void AddNoisePickHandler::setLength(short value)
{
  noiseLength = value;
}

NoiseShape AddNoisePickHandler::getShape() const
{
  return shape;
}

void AddNoisePickHandler::setShape(const NoiseShape &value)
{
  shape = value;
}

NoisePickType AddNoisePickHandler::getPickType() const
{
  return pickType;
}

void AddNoisePickHandler::setPickType(const NoisePickType &value)
{
  pickType = value;
}

void AddNoisePickHandler::setNoiseHeight(short value)
{
  noiseHeight = value;
}



void AddNoisePickHandler::generatePoints(double probability)
{
  noiseCreator.GeneratePoints(probability, pickType, shape, radius, noiseHeight, noiseLength);

  // Update the input model for rendering
  inputModel->Update(skel);
  skeletonModel->Update(skel);
  renderer.pointRenderer->UpdateInputModelPoints();
  renderer.pointRenderer->UpdateSkeletonPoints();
  graph.reset();
  graph.construct(inputModel->GetThinPoints());
}


AddNoisePickHandler::AddNoisePickHandler(FeaturePoints& featurePoints, std::shared_ptr<SkeletonModel> inputModel,
                                         std::shared_ptr<SkeletonModel> skeletonModel, surface::Graph& graph, collapseSkel3d& skel,
                                         Renderer& renderer) :
  importance(skel.getImportance()),
  edt(skel.getEDT()),
  thinImage(skel.getThinImage()),
  width(thinImage.getWidth()),
  height(thinImage.getHeight()),
  depth(thinImage.getDepth()),
  bounds(width, height, depth),
  featurePoints(featurePoints),
  inputModel(inputModel),
  skeletonModel(skeletonModel),
  skel(skel),
  graph(graph),
  noiseCreator(thinImage, graph, inputModel),
  renderer(renderer)
{
}





void AddNoisePickHandler::OnPick(double x, double y, double z, bool picked_something)
{
  if (!picked_something) return;

  coord3s point(round(x), round(y), round(z));
  if (noiseLength == 1)
    noiseCreator.AddSingleLineSurface(pickType, shape, point, radius, noiseHeight);
  else
    noiseCreator.AddRandomStripe(pickType, shape, point, radius, noiseHeight, noiseLength);
 
  // Update the input model for rendering
  inputModel->Update(skel);
  skeletonModel->Update(skel);
  renderer.pointRenderer->UpdateInputModelPoints();
  renderer.pointRenderer->UpdateSkeletonPoints();
  graph.reset();
  graph.construct(inputModel->GetThinPoints());
  
}
