#include "CutSetRenderer.h"

#include "SkeletonController.h"

CutSetRenderer::CutSetRenderer(SkeletonController &skeletonController)
:
  p_skeletonController(&skeletonController)
{

}

void CutSetRenderer::draw()
{
  auto &cutcontroller = p_skeletonController->getCutController();
  if (! cutcontroller.hasCutSet()) return;
  auto &cutset = cutcontroller.getCutSet();

  std::vector<Point3d> points;
  auto &graph = p_skeletonController->GetGraph();
  auto &ren = p_skeletonController->GetRenderer();

  for (auto const & cut : cutset.getCuts())
  {
    points.clear();

    auto &path = *(cut.second->up_path);
    for (auto p_node : path)
    {
      auto n = graph.boundary->at(p_node->id);
      n.value = 0.4; //color
      points.push_back(std::move(n));
    }
    ren.draw_cubes(points);
  }
}
