#include "GraphRender.h"
#include "utils.h"
#include "glwrapper.h"
#include <iostream>

using namespace std;



void GraphRenderer::draw(const surface::Graph &g, const vector<Point3d> &boundary)
{
  glColor3f(0, 0, 0);
  glPointSize(2.0f);

  glDisable(GL_LIGHTING);

  glBegin(GL_POINTS);
  for (surface::Graph::Nodes::const_iterator it = g.nodes.begin(); it != g.nodes.end();
       ++it)
  {
    const surface::Graph::Node* n = it->second;

    const Point3d &p = boundary[n->id];

    glVertex3f(p.x, p.y, p.z);
  }
  glEnd();

  glColor3f(0, 1, 0);
  glBegin(GL_LINES);
  for (surface::Graph::Nodes::const_iterator it = g.nodes.begin(); it != g.nodes.end();
       ++it)
  {
    const surface::Graph::Node* n = it->second;

    const Point3d &p = boundary[n->id];

    for (surface::Graph::Node::Neighbors::const_iterator it = n->neighbors.begin();
         it != n->neighbors.end(); ++it)
    {
      const surface::Graph::Node* n2 = it->first;
      float w = (it->second - 1) / (sqrt(3) -
                                    1);       //normalize weight in [0,1] for colormapping

      float col[3];
      float2rgb(w, col);

      const Point3d &p2 = boundary[n2->id];

      glColor3fv(col);
      glVertex3f(p.x, p.y, p.z);
      glVertex3f(p2.x, p2.y, p2.z);
    }
  }
  glEnd();

}

void GraphRenderer::draw_dist(const surface::Graph &g, const vector<Point3d> &boundary,
                              const vector<float> &dist, float thr)
{
  glColor3f(0, 0, 0);
  glPointSize(4.0f);

  glDisable(GL_LIGHTING);

  glBegin(GL_POINTS);
  for (surface::Graph::Nodes::const_iterator it = g.nodes.begin(); it != g.nodes.end();
       ++it)
  {
    const surface::Graph::Node* n = it->second;

    const Point3d &p = boundary[n->id];

    float w = dist[n->id];

    if (w < 1e-7f) continue;

    float col[3];
    float2rgb(w, col);

    glColor3fv(col);
    glVertex3f(p.x, p.y, p.z);
  }
  glEnd();
}

