#include "Helpers.h"

#include <glm/glm.hpp>
#include <Eigen/Dense>

using namespace Eigen;
using namespace glm;

Vector2f VecConvert(const vec2& vec)
{
  return Vector2f(vec.x, vec.y);
}

Vector3f VecConvert(const vec3& vec)
{
  return Vector3f(vec.x, vec.y, vec.z);
}

Vector4f VecConvert(const vec4& vec)
{
  return Vector4f(vec.x, vec.y, vec.z, vec.w);
}

vec4 VecConvert(const Vector4f& vec)
{
  return vec4(vec[0], vec[1], vec[2], vec[3]);
}

glm::vec3 VecConvert(const Point3d vec)
{
  return glm::vec3(vec[0], vec[1], vec[2]);
}

vec3 VecConvert(const Vector3f& vec)
{
  return vec3(vec[0], vec[1], vec[2]);
}

vec2 VecConvert(const Vector2f& vec)
{
  return vec2(vec[0], vec[1]);
}
