#pragma once
#include <QMainWindow>
#include <thread>
#include "ui_MainWindow.h"
#include "SkeletonController.h"
#include "SegmentationHandler.h"
#include "VolumeOpenController.h"

namespace Ui {
  class MainWindow;
}

class MainWindow : public QMainWindow
{
  Q_OBJECT

public:
  explicit MainWindow(QWidget *parent = 0);
  ~MainWindow();

  void SetSkeletonController(SkeletonController* controller)
  {
    skeletonController = controller;
  }

  void SetVolumeOpenController(VolumeOpenController* controller)
  {
    volumeOpenController = controller;
  }

  void SetGlutThread(std::thread* glutThread)
  {
    this->glutThread = glutThread;
  }

  void connectGlutWindowSignals();

  void CloseWindow();

private:
  Ui::MainWindow *ui;
  SkeletonController* skeletonController = nullptr;
  VolumeOpenController* volumeOpenController = nullptr;
  std::thread* glutThread = nullptr;

  void setupComboboxes();
  SkeletonCreationOptions getSkeletonCreationOptions();
private slots:
  void on_skeletonizeButton_clicked();
  void on_setDefaultButton_clicked();
  void on_actionExit_triggered();

  // QWidget interface
  void on_inputRenderComboBox_currentIndexChanged(int index);

  void on_skeletonRenderComboBox_currentIndexChanged(int index);

  void on_boundaryRenderComboBox_currentIndexChanged(int index);

  void on_splatSizeOffsetSpinBox_valueChanged(double value);

  void on_ballSizeOffsetSpinBox_valueChanged(double value);

  void on_featurePointsCheckBox_stateChanged(int arg1);

  void on_minAlphaSlider_valueChanged(int position);

  void on_alphaSlopeSlider_valueChanged(int position);

  void on_maxImportanceSlider_valueChanged(int position);

  void on_statsCheckBox_toggled(bool checked);

  void on_pickModeCombobox_currentIndexChanged(int index);

  void on_noiseTypeComboBox_currentIndexChanged(int index);

  void on_noiseShapeComboBox_currentIndexChanged(int index);

  void on_noiseRadiusSpinbox_valueChanged(int arg1);

  void on_showInputRadioButton_toggled(bool checked);

  void on_showReconstructionRadioButton_toggled(bool checked);

  void on_reconstructButton_clicked();

  void on_generatePointsButton_clicked();

  void on_computeSaliencyButton_clicked();

  void on_saliencyImportanceSpinbox_valueChanged(double arg1);

  void on_keepLargestComponentCheckBox_clicked(bool checked);

  void on_actionSave_triggered();

  void on_cutMethodComboBox_activated(int index);

  void on_computeCutsButton_clicked();

  void on_noiseHeightSpinBox_valueChanged(int arg1);

  void on_importanceThresholdSlider_sliderReleased();

  void on_saliencyThresholdSlider_sliderReleased();

  void on_saliencyMethodComboBox_activated(int index);

  void on_cutTransformMethodComboBox_activated(int index);

  void on_applyCutTransformPushButton_clicked();

  void on_splatBackfaceCullingCheckBox_toggled(bool checked);

  void on_scalarFieldComboBox_currentIndexChanged(int index);

  void on_drawStreamlinesCheckBox_toggled(bool checked);

  void on_noiseLengthSpinBox_valueChanged(int arg1);

  void on_actionImport_triggered();

  void on_actionOpen_triggered();

  void on_actionExport_Volume_triggered();

  void on_actionExport_Surface_triggered();

public slots:
  void on_pickChanged();

protected:
  void closeEvent(QCloseEvent* event);
};
