#include "ShowCorridorGraphHandler.h"

#include "PointSearch.h"
#include "skelrender.h"
#include "SkeletonController.h"
#include "surface/PlaneTrace.h"
#include "surface/Graph.h"
#include "cuts/PlaneTraceCutCreator.h"
#include "cuts/PerpToSkelCutCreator.h"

#include <sstream>


ShowCorridorGraphHandler::ShowCorridorGraphHandler(SkeletonController &skeletonController)
:
  r_skeletonController(skeletonController),
  d_sp_selected(false),
  d_sp_idx(0)
{

}

void ShowCorridorGraphHandler::onPick(double x, double y, double z, bool picked_something)
{
  std::unique_lock<std::mutex> lck (d_mtx);
  if (picked_something)
  {
    Point3d pick(x, y, z);
    //size_t picked_cut = cutSet->pickCut(pick);
    d_sp_idx = r_skeletonController.GetFeaturePoints().skelSearch->closest(pick);
    d_sp_selected = true;
    //compute the cutband
    //todo: should maybe happen asynchronously

    std::unique_ptr<cuts::PlaneTraceCutCreator> tmp_cutCreator(
          new cuts::PerpToSkelCutCreator(
            r_skeletonController.GetFeaturePoints(),
            r_skeletonController.GetGraph(),
            r_skeletonController.GetSkel(),
            //skelmodel has uninitialized normals,
            //this works als long as we're working on the input model
            r_skeletonController.GetInputModel()->GetThinNormals()));

    surface::PlaneTrace::Plane cutPlane = tmp_cutCreator->makeCutPlane(d_sp_idx);

    const FeaturePoints::FeatureTriple &feature_pair =
        r_skeletonController.GetFeaturePoints().featurePoints[d_sp_idx];
    int seed_boundary_index = feature_pair.first;
    surface::Graph::Node *seed_node = r_skeletonController.GetGraph().nid2nodes.at(seed_boundary_index);

    up_cutband =
          surface::makeCutBand(
            r_skeletonController.GetGraph(),
            8.0,
            seed_node,
            cutPlane);
  }
  else
  {
    d_sp_selected = false;
    up_cutband.reset();
  }
  //raise signal that stuff changed
  emit pickChanged();
}

void ShowCorridorGraphHandler::draw(Renderer &ren)
{
  std::unique_lock<std::mutex> lck (d_mtx);
  if (!d_sp_selected)
    return;
  
  drawCorridorGraph(ren);
}

void ShowCorridorGraphHandler::drawCorridorGraph(Renderer &ren)
{
  std::vector<Point3d> points;
  for (auto& node : up_cutband->nodes)
  {
    points.push_back(up_cutband->boundary->at(node.second->id));
  }

  ren.draw_cubes(points);
}
