#include "SkeletonPointRenderer.h"

void SkeletonPointRenderer::DrawInputModel()
{
  thinInputModelRenderer->Draw();
}

void SkeletonPointRenderer::DrawReconstructionModel()
{
  if (thinReconstructionRenderer)
    thinReconstructionRenderer->Draw();
}

void SkeletonPointRenderer::DrawThinSkeletonPoints()
{
  thinSkeletonModelRenderer->Draw();
}

void SkeletonPointRenderer::DrawThickSkeletonPoints()
{
  thickSkeletonModelRenderer->Draw();
}

void SkeletonPointRenderer::UpdateSkeletonPoints()
{
  auto thinSkeletonModelSurfels = CreateSurfelList(skeletonModel->GetThinPoints(), 
    skeletonModel->GetThinNormals(), defaultColor, scalarVolume, scalarMin, scalarMax);
  auto thickSkeletonModelSurfels = CreateSurfelList(skeletonModel->GetSkelPoints(), 
    skeletonModel->GetSkelNormals(), defaultColor, scalarVolume, scalarMin, scalarMax);

  thinSkeletonModelRenderer->SetPoints(thinSkeletonModelSurfels);
  thickSkeletonModelRenderer->SetPoints(thickSkeletonModelSurfels);
}

void SkeletonPointRenderer::UpdateInputModelPoints()
{
  auto thinInputSurfels = CreateSurfelList(inputModel->GetThinPoints(), inputModel->GetThinNormals(), defaultColor, nullptr, 0, 0);
  thinInputModelRenderer->SetPoints(thinInputSurfels);
}

void SkeletonPointRenderer::SetScalarVolume(Volume<float>* scalarVolume, float scalarMin, float scalarMax)
{
  if (this->scalarVolume == scalarVolume && 
      this->scalarMin == scalarMin &&
      this->scalarMax == scalarMax)
    return;

  this->scalarVolume = scalarVolume;
  this->scalarMax = scalarMax;
  this->scalarMin = scalarMin;
  UpdateSkeletonPoints();
}

void SkeletonPointRenderer::SetReconstructionModel(const std::shared_ptr<SkeletonModel>& reconstructionModel)
{
  this->reconstructionModel = reconstructionModel;

  auto thinInputSurfels = CreateSurfelList(reconstructionModel->GetThinPoints(),
    reconstructionModel->GetThinNormals(), defaultColor, nullptr, 0, 0);

  if (thinReconstructionRenderer)
  {
    thinReconstructionRenderer->SetPoints(thinInputSurfels);
  }
  else
  {
    thinReconstructionRenderer.reset(new PointSetRenderer(thinInputSurfels, canvasSize));
    pointSetRenderers.push_back(thinReconstructionRenderer.get());
  }

}
