#include "Surfel.h"
#include <utils.h>
#include <glm/gtc/type_ptr.hpp>

Surfel ComputeCircularSurfel(const Point & point, float scale)
{
  Surfel surfel;
  surfel.Position = point.Position;
  surfel.Color = point.Color;

  if (glm::dot(point.Normal, point.Normal) < 1.0e-6)
    return surfel;

  glm::vec3 r = glm::sphericalRand(1.f);
  glm::vec3 u = glm::normalize(glm::cross(point.Normal, r));
  glm::vec3 v = glm::cross(point.Normal, u);

  surfel.U = scale * u;
  surfel.V = scale * v;

  return surfel;
}

std::vector<Surfel> CreateSurfelList(std::vector<Point3d>& points, std::vector<Point3d>& normals, Point3d defaultColor, Volume<float>* scalars, float min, float max)
{
  std::vector<Surfel> surfels;
  surfels.reserve(points.size());

  for (int i = 0; i < points.size(); i++)
  {
    glm::vec3 p = VecConvert(points[i]);
    glm::vec3 normal = VecConvert(normals[i]);
    glm::vec3 color = VecConvert(defaultColor);

    // Override default color with rainbow color schemes if scalars is non-zero
    if (scalars)
    {
      float value = ((*scalars)(coord3s(p.x, p.y, p.z)) - min) / (max - min);
      float2rgb(value, glm::value_ptr(color));
    }

    Point point = { p, color, normal };
    Surfel surfel = ComputeCircularSurfel(point, 1);
    surfels.push_back(surfel);
  }

  return surfels;
}
