﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSharpDeps.Scopes
{
    public class File
    {
        public string Path { get; set; }

        protected Dictionary<string, Namespace> namespaces = new Dictionary<string, Namespace>();

        public Dictionary<string, Namespace> Namespaces
        {
            get { return namespaces; }
        }

        public File(string path)
        {
            Path = path;
        }

        public void AddNamespace(Namespace ns)
        {
            if (Namespaces.ContainsKey(ns.FullName))
            {
                Namespaces[ns.FullName].MergeNamespace(ns);
            }
            else
            {
                Namespaces[ns.FullName] = ns;
            }
        }
    }
}
