﻿using ICSharpCode.NRefactory.CSharp;
using ICSharpCode.NRefactory.CSharp.Resolver;

namespace CSharpDeps.Visitors
{
    abstract class Visitor : DepthFirstAstVisitor
    {
        protected CSharpAstResolver Resolver;

        public Visitor(CSharpAstResolver resolver)
        {
            Resolver = resolver;
        }

        protected void VisitChildren(AstNode node, Visitor visitor)
        {
            foreach (var child in node.Children)
            {
                child.AcceptVisitor(visitor);
            }

            visitor.VisitedChildren(node);
        }

        protected override void VisitChildren(AstNode node)
        {
            base.VisitChildren(node);

            this.VisitedChildren(node);
        }

        protected virtual void VisitedChildren(AstNode node)
        {

        }
    }
}
