﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSharpMetrics.Scopes
{
    public class Class
    {
        public Namespace Namespace { get; private set; }

        public int LOC { get; set; }

        public int CLOC { get; set; }

        protected Dictionary<string, Class> children = new Dictionary<string, Class>();

        public Dictionary<string, Class> Children
        {
            get { return children; }
        }

        protected List<Method> methods = new List<Method>();

        public List<Method> Methods
        {
            get { return methods; }
        }

        public Class Parent { get; private set; }

        public string Name { get; private set; }

        public string FullName
        {
            get { return Namespace.IsGlobal() ? Name : string.Format("{0}.{1}", Namespace.FullName, Name); }
        }

        public int NrFields { get; set; }

        public int NrMethods
        {
            get { return Methods.Count; }
        }

        public int Complexity
        {
            get { return Methods.Sum(m => m.Complexity); }
        }

        public int Invocations
        {
            get { return Methods.Sum(m => m.Invocations); }
        }

        public Class(Namespace ns, Class parent, string name)
        {
            Namespace = ns;
            Parent = parent;
            Name = name;
        }

        public void AddChild(Class child)
        {
            if (Children.ContainsKey(child.Name))
            {
                Children[child.Name].MergeClass(child);
            }
            else
            {
                Children[child.Name] = child;
            }
        }

        public void MergeClass(Class other)
        {
            foreach (Class klass in other.Children.Values)
            {
                AddChild(klass);
            }

            NrFields += other.NrFields;

            Methods.AddRange(other.Methods);
        }

        public void AddMethod(Method method)
        {
            Methods.Add(method);
        }
    }
}
