﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CSharpMetrics.Scopes
{
    public class Method
    {
        public Class Class { get; private set; }

        public string Name { get; private set; }

        protected List<string> parameters = new List<string>();

        public List<string> Params
        {
            get { return parameters; }
        }

        public int NrParams
        {
            get { return Params.Count; }
        }

        public int Complexity { get; set; }

        public int Invocations { get; set; }

        public int MaxDepth { get; set; }

        public int LOC { get; set; }

        public int CLOC { get; set; }

        public string Prototype
        {
            get { return string.Format("{0}({1})", Name, string.Join(", ", Params)); }
        }

        public Method(Class klass, string name)
        {
            Class = klass;
            Name = name;
            Invocations = 0;
            Complexity = 1;
        }

        public void AddParam(string param)
        {
            Params.Add(param);
        }
    }
}
