﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ICSharpCode.NRefactory.CSharp;
using CSharpMetrics.Scopes;

namespace CSharpMetrics.Visitors
{
    class ClassVisitor : Visitor
    {
        protected Class Class { get; set; }

        public ClassVisitor(Class klass)
        {
            Class = klass;
        }

        protected override void VisitedChildren(AstNode node)
        {
            Class.LOC = LOC;
            Class.CLOC = CLOC;
        }

        public override void VisitTypeDeclaration(TypeDeclaration typeDeclaration)
        {
            switch (typeDeclaration.ClassType)
            {
                case ClassType.Class:
                case ClassType.Struct:
                    var klass = new Class(Class.Namespace, Class, typeDeclaration.Name);

                    VisitChildren(typeDeclaration, new ClassVisitor(klass));

                    Class.AddChild(klass);
                    break;
                case ClassType.Enum:
                case ClassType.Interface:
                    // TODO: Evaluate
                    base.VisitTypeDeclaration(typeDeclaration);
                    break;
            }
        }

        public override void VisitMethodDeclaration(MethodDeclaration methodDeclaration)
        {
            var method = new Method(Class, methodDeclaration.Name);

            methodDeclaration.AcceptVisitor(new MethodVisitor(method));

            Class.AddMethod(method);

            base.VisitMethodDeclaration(methodDeclaration);
        }

        public override void VisitPropertyDeclaration(PropertyDeclaration propertyDeclaration)
        {
            Class.NrFields++;

            base.VisitPropertyDeclaration(propertyDeclaration);
        }

        public override void VisitFieldDeclaration(FieldDeclaration fieldDeclaration)
        {
            Class.NrFields++;

            base.VisitFieldDeclaration(fieldDeclaration);
        }
    }
}
