import SocketServer
import socket
import sys
import traceback
import threading
from ctypes import *
from ctypes.wintypes import *
import struct, array
from MExceptions import *



"""	
class TBroadcastServer:
### See http://vizible.wordpress.com/2009/01/31/python-broadcast-udp/ for broadcast 
	class TBroadcastServer:
		def __init__(self):
			self.socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
			self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
			self.socket.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
			self.socket.bind(('', port))
			self.thread = threading.Thread(target=self.run)
			self.terminate = False
		
		def run(self):
			while not self.terminate:
				try:
					message, address = s.recvfrom(8192)
					print "Got data from", address
					# Acknowledge it.
					s.sendto("I am here", address)
				except (KeyboardInterrupt, SystemExit):
					raise
				except:
					traceback.print_exc()
"""

class TSocketServer:

	class MyTcpHandler(SocketServer.BaseRequestHandler):
		def handle(self):
			msg = self.request.recv(8192)
			response = self.server.server.OnMessage(msg,self.request.getpeername()[0])
			self.request.send( str(response) )
		
	def OnMessage(self, msg, address):
		print "Please rebind callback: got msg %s" % msg
		
	def __init__(self, host, port):
		self.host = host
		self.port = port
		#class ThreadedTCPServer(SocketServer.ThreadingMixIn, SocketServer.TCPServer):
		class ThreadedTCPServer(SocketServer.TCPServer):
			pass
			
		# Create the server, binding to localhost on port 9999
		try:
			server = ThreadedTCPServer((self.host, self.port), self.MyTcpHandler)
		except Exception as e:
			raise TCannotStartServer( ("Cannot open listening socket %s:%s.\n\n%s" % (self.host,self.port, str(e)) ) )
			
		server.server = self

		server_thread = threading.Thread(target=server.serve_forever)
		# Exit the server thread when the main thread terminates
		server_thread.setDaemon(True)
		server_thread.start()	

class TSocketClient:
	def __init__(self, host, port):
		self.host = host
		self.port = port
		
	def sendMessage(self, msg):
		# Create a socket (SOCK_STREAM means a TCP socket)
		sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)

		# Connect to server and send data
		try:
			sock.connect((self.host, self.port))
		except socket.error:
			raise TServerNotAvailable("Cannot connect to %s:%i" % (self.host, self.port) )
			
		try:
			sock.send(msg + "\n")
		except socket.error:
			raise TCommunicationError("Unknown error")

		# Receive data from the server and shut down
		received = sock.recv(8192)
		sock.close()
		return received

	def getHostAndPort(self):
		return (self.host, self.port)
		
