import ctypes
from ctypes import *

def GetAllWindows(parent=None):
	'Returns handles to windows with matching titles'
	hwnds = []
	def EnumCB(hwnd, lparam, hwnds=hwnds):
		title = c_buffer(' ' * 256)
		ctypes.windll.user32.GetWindowTextA(hwnd, title, 255)
		hwnds.append( (hwnd,title.value) )
		return 1

	EnumWindowsProc = ctypes.WINFUNCTYPE(c_int, c_int, c_int)
	if parent is not None:
		ctypes.windll.user32.EnumChildWindows(parent, EnumWindowsProc(EnumCB), 0)
	else:
		ctypes.windll.user32.EnumWindows(EnumWindowsProc(EnumCB), 0)
	return hwnds		

def FreeConsole():
	ctypes.windll.kernel32.FreeConsole()	
	
def AllocConsole():
	ctypes.windll.kernel32.AllocConsole()

def AttachConsole(pid):
	ctypes.windll.kernel32.AttachConsole(pid)

def GetCurrentProcessId():
	return ctypes.windll.kernel32.GetCurrentProcessId()

def GetStdHandle(stdhandle):
	return ctypes.windll.kernel32.GetStdHandle(stdhandle)
	
def WriteConsole(handle, text):
	written = c_uint()
	return ctypes.windll.kernel32.WriteConsoleA(handle, text, len(text), byref(written), 0)

def WriteFile(handle, text):
	written = c_uint()
	return ctypes.windll.kernel32.WriteFile(handle, text, len(text), byref(written), 0)
	
def FlushFileBuffers(handle):
	return ctypes.windll.kernel32.FlushFileBuffers(handle)

	