import time
import wx

class TAboutBox(wx.Frame):
	def __init__(self, parent, p_dBranding, p_iTimeout=0):
		wx.Frame.__init__(self, parent, style=wx.SIMPLE_BORDER|wx.STAY_ON_TOP|wx.FRAME_NO_TASKBAR)
		self.SetBackgroundColour(wx.WHITE)
		self.CenterOnParent(wx.BOTH)

		#---- Text

		l_sTitle = '%s %s\n'%(p_dBranding['appnamelong'],p_dBranding['appversion'])


		l_sText = 'Unlimited license'

		l_sText += '\n%s\n'%p_dBranding['copy']

		#---- GUI

		l_cBitmap = wx.Bitmap("logo.bmp", wx.BITMAP_TYPE_BMP)
		l_gBitmap = wx.StaticBitmap(self, -1, l_cBitmap)

		l_gTitle = wx.StaticText(self, -1, l_sTitle)
		font = l_gTitle.GetFont()
		font.SetWeight( wx.FONTWEIGHT_BOLD )
		l_gTitle.SetFont( font )

		l_gText = wx.StaticText(self, -1, l_sText)
		font = l_gText.GetFont()
		font.SetFaceName('Arial')
		font.SetPointSize(8)
		l_gText.SetFont( font )

		l_gLine			= wx.StaticLine(self)

		l_gOkButton = wx.Button(self, -1, "Close" )
		l_gOkButton.Bind( wx.EVT_BUTTON, self.Close )

		szButtons = wx.BoxSizer(wx.HORIZONTAL)
		szButtons.Add(l_gOkButton,0,wx.FIXED_MINSIZE|wx.ALL,2)

		szText = wx.BoxSizer(wx.VERTICAL)
		szText.Add(l_gTitle,0, wx.EXPAND|wx.ALL, 10)
		szText.Add(l_gText,0, wx.EXPAND|wx.ALL, 10)

		szText.AddStretchSpacer(1)

		szText.AddStretchSpacer(1)

		szText.Add(l_gLine,0, wx.EXPAND|wx.ALL, 3)
		szText.Add(szButtons,0, wx.ALIGN_CENTER |wx.ALL, 10)

		szMain	= wx.BoxSizer(wx.HORIZONTAL)
		szMain.Add(l_gBitmap,0, wx.EXPAND|wx.ALL, 0)
		szMain.Add(szText,1, wx.EXPAND|wx.ALL, 0)

		self.SetSizer(szMain)
		self.SetAutoLayout(True)
		self.Layout()
		self.Show()

		self.SetSize( wx.Size(l_cBitmap.GetSize().x + 250, l_cBitmap.GetSize().y) )

		#-- Timeout (for splash screen)
		if p_iTimeout > 0:
			self.timer = wx.Timer(self)
			self.Bind(wx.EVT_TIMER, self.OnTimer)
			self.timer.Start(p_iTimeout*1000, True)
			l_gOkButton.Enable(False)

	def Close(self,evt=None):
		self.Destroy()

	def OnTimer(self,evt):
		self.timer.Stop()
		self.Close()

