'''OpenGL extension ARB.framebuffer_object

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.framebuffer_object to provide a more 
Python-friendly API
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.framebuffer_object import *
### END AUTOGENERATED SECTION
from OpenGL.lazywrapper import lazy 

glGenFramebuffers = wrapper.wrapper(glGenFramebuffers).setOutput(
                'framebuffers', 
                lambda x: (x,), 
                'n')
                
glGenRenderbuffers = wrapper.wrapper(glGenRenderbuffers).setOutput(
                'renderbuffers', 
                lambda x: (x,), 
                'n')


@lazy( glDeleteFramebuffers )
def glDeleteFramebuffers( baseOperation, n, framebuffers=None ):
	"""glDeleteFramebuffers( framebuffers ) -> None 
	"""
	if framebuffers is None:
		framebuffers = arrays.GLuintArray.asArray( n )
		n = arrays.GLuintArray.arraySize( framebuffers )
	return baseOperation( n, framebuffers )
