import cushions
import sta_globals
import time
import calendar
import sta_utils
import sta_gui
import sta_calendar
from sta_gl 			import CanvasBase

import wx
from OpenGL.GL			import *
from OpenGL.GLUT 		import *
from OpenGL.GLU 		import *

#/////////////////////////////////////////////////////////////////////////
#						Horizontal Metric Canvas
#/////////////////////////////////////////////////////////////////////////

class HorizontalMetricCanvas(CanvasBase):

	def __init__(self, parent, *args, **kwds):
		CanvasBase.__init__(self, *args, **kwds)
		
		self.cMainApp		= parent 
		self.bUpdate		= True		# Reconfigure draw
		
		self.mode			= 0 		# Display mode (0:none, 1:releases)
		
		self.iMx			= 0
		self.iMy			= 0	
		
		self.years			= []
		self.months			= []
		
		self.bClearDClick	= False
		
		self.showRuler		= True		# Show ruler
		self.iIntervalEdit	= 1			# 1 = left, 0 = right
		self.iSelected		= -1		# Selected snapshot
		
		self.cMenu = wx.Menu("Snapshot")
		self.cMenu.Append(101,"Rename")
		self.cMenu.Append(102,"Delete")
		self.cMenu.Append(103,"Select date")
		
		self.Bind(wx.EVT_MENU, self.cbRenameSnapshot, id=101)
		self.Bind(wx.EVT_MENU, self.cbDeleteSnapshot, id=102)
		self.Bind(wx.EVT_MENU, self.cbDateSnapshot, id=103)
		
#========================================================================
# 															OnMenu
#========================================================================
	def cbDeleteSnapshot(self,evt):
		if (self.iSelected >= 0):
			del sta_globals.cSTAPrj.lSnapshots[self.iSelected]
			self.cMainApp.saveSnapshots()
			self.iSelected = -1
			self.RefreshEx()
			
	def cbRenameSnapshot(self,evt):
		if (self.iSelected < 0):
			return
		l_sName = sta_globals.cSTAPrj.lSnapshots[self.iSelected][1]
		l_dlg = sta_gui.CInputTextDlg('Snapshot name','Input name: ',l_sName,self.cMainApp.mainFrame)
		l_iRetCode = l_dlg.ShowModal()
		if (l_iRetCode == wx.ID_OK):
			sta_globals.cSTAPrj.lSnapshots[self.iSelected][1] = l_dlg.sText
			self.cMainApp.saveSnapshots()
			self.RefreshEx()
		l_dlg.Destroy()
		
	def cbDateSnapshot(self,evt):
		if (self.iSelected < 0):
			return
		dlg = sta_calendar.CCalendar(sta_globals.cSTAPrj.lSnapshots[self.iSelected][0],self,-1,'Choose a date')
		l_bCalendar = dlg.ShowModal()
		if (l_bCalendar == wx.ID_OK):
			sta_globals.cSTAPrj.lSnapshots[self.iSelected][0] = dlg.iTime
			self.cMainApp.saveSnapshots()
			self.RefreshEx()
		dlg.Destroy()
		
#========================================================================
# 															OnMouse
#========================================================================
	
	def OnMouseMotion(self, evt):
		
		self.iMx, self.iMy = evt.GetPosition()
		self.iMx = max(self.iMx,0)
		self.iMx = min(self.iMx,self.size.width)
		self.iMy = max(self.iMy,0)
		self.iMy = min(self.iMy,self.size.height)
		
		#------------------------- Handle interval selection ---
		if evt.m_rightDown:
			l_iInterval = self.iMx * sta_globals.fUnitX + sta_globals.fOffsetX
			if (self.iIntervalEdit == 1):
				if (l_iInterval > sta_globals.iStartFocusInterval):
					sta_globals.iEndFocusInterval = l_iInterval
				else:
					self.iIntervalEdit = 0
					sta_globals.iStartFocusInterval = l_iInterval
			else:
				if (l_iInterval < sta_globals.iEndFocusInterval):
					sta_globals.iStartFocusInterval = l_iInterval
				else:
					self.iIntervalEdit = 1
					sta_globals.iEndFocusInterval = l_iInterval
					
			self.RefreshEx()
			
		#--------------------------- Handle snapshot setting ---
		if evt.m_leftDown:
			if (self.iSelected >= 0):
				sta_globals.cSTAPrj.lSnapshots[self.iSelected][0] = self.iMx * sta_globals.fUnitX + sta_globals.fOffsetX
				self.cMainApp.saveSnapshots()
				self.RefreshEx()
		#-------------------------------------------------------
		
	def OnRightMouseDown(self, evt):
		sta_globals.iStartFocusInterval = self.iMx * sta_globals.fUnitX + sta_globals.fOffsetX
		sta_globals.iEndFocusInterval = sta_globals.iStartFocusInterval 
		self.RefreshEx()
		
	def OnRightMouseUp(self, evt):
		if self.bClearDClick:
			self.bClearDClick = False
		else:
			if (self.iIntervalEdit == 1):
				sta_globals.iEndFocusInterval = self.iMx * sta_globals.fUnitX + sta_globals.fOffsetX
			else:
				sta_globals.iStartFocusInterval = self.iMx * sta_globals.fUnitX + sta_globals.fOffsetX
			if (sta_globals.iStartFocusInterval == sta_globals.iEndFocusInterval):
				sta_globals.iStartFocusInterval		= -1
				sta_globals.iEndFocusInterval		= -1
		self.RefreshEx()
	
	def OnRightMouseDclick(self,evt):
		sta_globals.iStartFocusInterval = self.iMx * sta_globals.fUnitX + sta_globals.fOffsetX
		sta_globals.iEndFocusInterval = sta_globals.iSelectedFilesEndTime+1
		self.bClearDClick = True
	
	def OnLeftMouseDclick(self,evt):
		self.iSelected = -1
		for l_iSnapshot in xrange(len(sta_globals.cSTAPrj.lSnapshots)):
			l_iPos = (sta_globals.cSTAPrj.lSnapshots[l_iSnapshot][0]-sta_globals.fOffsetX)/sta_globals.fUnitX
			if abs(l_iPos-self.iMx)<=5:
				self.iSelected = l_iSnapshot
				break
		if (self.iSelected < 0):
			l_sName = ''
			l_dlg = sta_gui.CInputTextDlg('Snapshot name','Input name: ','',self.cMainApp.mainFrame)
			l_iRetCode = l_dlg.ShowModal()
			if (l_iRetCode == wx.ID_OK):
				l_sName = l_dlg.sText
			l_dlg.Destroy()
			sta_globals.cSTAPrj.lSnapshots.append([self.iMx * sta_globals.fUnitX + sta_globals.fOffsetX,l_sName])
			sta_globals.cSTAPrj.lSnapshots.sort(cmp=lambda x,y: cmp(x[0],y[0]))
			self.cMainApp.saveSnapshots()
			self.RefreshEx()
		else:
			self.PopupMenu(self.cMenu)
		
	def OnLeftMouseDown(self, evt):
		self.iSelected = -1
		for l_iSnapshot in xrange(len(sta_globals.cSTAPrj.lSnapshots)):
			l_iPos = (sta_globals.cSTAPrj.lSnapshots[l_iSnapshot][0]-sta_globals.fOffsetX)/sta_globals.fUnitX
			if abs(l_iPos-self.iMx)<=5:
				self.iSelected = l_iSnapshot
				break
		
	def OnLeftMouseUp(self, evt):
		self.RefreshEx()
		
#========================================================================
# 							State update
#========================================================================

	#---------------------------------------------- Update time scale ---
	def updateTimeScale(self):
		self.years  = []
		self.months = []
		lStartTime = time.gmtime(sta_globals.iSelectedFilesStartTime)
		lEndTime = time.gmtime(sta_globals.iSelectedFilesEndTime)        
		
		if (lStartTime[0] < lEndTime[0]):
			for i in range(lStartTime[1]+1,13):
				self.months.append(calendar.timegm((lStartTime[0],i,1,0,0,0)))
			for i in range(2,lEndTime[1]+1):
				self.months.append(calendar.timegm((lEndTime[0],i,1,0,0,0)))
			for i in range(lStartTime[0]+1,lEndTime[0]):
				for j in range(2,13):
					self.months.append(calendar.timegm((i,j,1,0,0,0)))
		else:	   
			for i in range(lStartTime[1]+1,lEndTime[1]+1):
				self.months.append(calendar.timegm((lStartTime[0],i,1,0,0,0)))
			
		for i in range(lStartTime[0]+1,lEndTime[0]+1):
			self.years.append((i,calendar.timegm((i,1,1,0,0,0))))

#========================================================================
# 								OnDraw
#========================================================================
	def OnDraw(self):   
		
		if self.bRendering:
			return
		self.glListSetup()
		
		glColor3f(1,1,1)
		if len(sta_globals.lSelectedFiles)>0:
			#----------------------------------------- Update configuration ---
			if (self.bUpdate):
				self.updateTimeScale()
				self.bUpdate = False
				
			#------------------------------------------- draw selected files ---
			
			glScalef(sta_globals.fRatioX,1,1)
			glTranslatef(-sta_globals.fOffsetX,0,0)
			
			fMargin 	= 1.5
						
			#------------- Draw focus interval ---
			if (sta_globals.iStartFocusInterval >= 0) or (sta_globals.iEndFocusInterval >= 0):
				
				l_iStartTime = sta_globals.iStartFocusInterval
				if (l_iStartTime < 0):
					l_iStartTime = sta_globals.iSelectedFilesStartTime
				
				l_iEndTime = sta_globals.iEndFocusInterval
				if (l_iEndTime < 0):
					l_iEndTime = sta_globals.iSelectedFilesEndTime
				
				glColor3f(0.75,0.80,0.95)
				glRectf(l_iStartTime,0,l_iEndTime,self.fSizeY)
				
				glColor3f(0.25,0.40,0.95)
				glRectf(l_iStartTime-sta_globals.fUnitX,0,l_iStartTime+sta_globals.fUnitX,self.fSizeY)
				glRectf(l_iStartTime-4*sta_globals.fUnitX,self.fSizeY/2-1,l_iStartTime,self.fSizeY/2+1)
				glRectf(l_iEndTime-sta_globals.fUnitX,0,l_iEndTime+sta_globals.fUnitX,self.fSizeY)
				glRectf(l_iEndTime,self.fSizeY/2-1,l_iEndTime+4*sta_globals.fUnitX,self.fSizeY/2+1)
			
			#---------------------- Draw scale ---
			if (self.showRuler):
				
				l_bShowMonths = (sta_globals.fRatioX) > (1.3 / 100000)
				
				for i in self.years:	      
					glColor3f(0.75,0.75,0.75)
					glRectf(i[1]-sta_globals.fUnitX,0,i[1],self.fSizeY)
					sta_utils.renderBitmapString(i[1]+4*sta_globals.fUnitX,0,GLUT_BITMAP_HELVETICA_10,str(i[0]),0)
					
					glColor3f(0,0,0)
					glRectf(i[1],0,i[1]+sta_globals.fUnitX,self.fSizeY)
					sta_utils.renderBitmapString(i[1]+5*sta_globals.fUnitX,0,GLUT_BITMAP_HELVETICA_10,str(i[0]),0)
				for i in self.months:
					glColor3f(0.75,0.75,0.75)
					glRectf(i-sta_globals.fUnitX,self.fSizeY/1.5,i,self.fSizeY)
					glColor3f(0,0,0)
					glRectf(i,self.fSizeY/1.5,i+sta_globals.fUnitX,self.fSizeY)
					
					if l_bShowMonths:
						l_iMonth = time.gmtime(i)[1]-1
						sta_utils.renderBitmapString(i-5*sta_globals.fUnitX,0,GLUT_BITMAP_HELVETICA_10,sta_globals.sMonths[l_iMonth],0)
			
			#------------------ Draw snapshots ---
			for l_iSnapshot in sta_globals.cSTAPrj.lSnapshots:
				glColor3f(0.95,0.10,0.10)
				glBegin(GL_TRIANGLES)
				glVertex2f(l_iSnapshot[0]-sta_globals.fUnitX*self.fSizeY/2,self.fSizeY)
				glVertex2f(l_iSnapshot[0]+sta_globals.fUnitX*self.fSizeY/2,self.fSizeY)
				glVertex2f(l_iSnapshot[0],0)
				glEnd()
				glColor3f(1.0,1.0,0.75)
				glRectf(l_iSnapshot[0]+sta_globals.fUnitX*self.fSizeY/3,0,l_iSnapshot[0]+sta_globals.fUnitX*(self.fSizeY/3+len(l_iSnapshot[1])*6),self.fSizeY/2)
				self.drawGlowString(l_iSnapshot[0]+sta_globals.fUnitX*(self.fSizeY/3+5),2,l_iSnapshot[1],cTextColor = (0.75,0.25,0.25),cGlowColor = (1.0,1.0,0.75))
			
			#-------------------------------------
		self.glListRun()
		
		# Save image
		glPixelStorei(GL_PACK_ALIGNMENT, 1)
		sta_globals.lPixelsHorizontal = glReadPixels(0,0,self.size.width,sta_globals.iHorizontalBar,GL_RGB,GL_UNSIGNED_BYTE)
		
