
import sta_gl_mixerunit
import sta_globals
import math

from sta_gl 			import CanvasBase
from OpenGL.GL 		import *
from OpenGL.GLUT 		import *
from OpenGL.GLU 		import *

#/////////////////////////////////////////////////////////////////////////
#						Mixer Canvas Project
#/////////////////////////////////////////////////////////////////////////
	   
class MixerCanvas_Project(CanvasBase):

	def __init__(self, parent, *args, **kwds):
		CanvasBase.__init__(self, *args, **kwds)
		
		self.lcUnits			= {}
		self.cObserver			= 0
		self.bInit				= True
		self.lThrasholds		= [100,80,60,40]
		self.fMixRatio			= 1
		
		self.cSelectedUnit		= 0
		self.bSelected			= False
		
#========================================================================
#																 OnMouse
#========================================================================
	
	def unitContains(self,l_cUnit,x,y):
		iX = l_cUnit.x
		iY = l_cUnit.y
		if (x >= iX-sta_globals.iUnitSize) and (x <= iX+sta_globals.iUnitSize) and (y >= iY-sta_globals.iUnitSize) and (y <=iY+sta_globals.iUnitSize):
			return True
		else:
			return False
	
	def OnLeftMouseDown(self, evt):
		
		self.bSelected		= False
		
		# Select units
		for i in self.lcUnits.values():
			if self.unitContains(i,self.lastx,self.lasty) and i.bActive:
				self.cSelectedUnit = i
				self.bSelected	 = True
		
		# Select observer
		if self.unitContains(self.cObserver,self.lastx,self.lasty):
			self.cSelectedUnit = self.cObserver
			self.bSelected	 = True
	
	def OnLeftMouseUp(self, evt):
		self.bSelected	 = False
		self.Refresh()
	
	def OnMouseMotion(self, evt):	   
		
		self.x, self.y = evt.GetPosition()
		
		if evt.Dragging() and evt.LeftIsDown():
			iDeltaX = self.x - self.lastx
			iDeltaY = self.y - self.lasty
			
			if self.bSelected:
			   self.cSelectedUnit.x = self.cSelectedUnit.x + iDeltaX 
			   self.cSelectedUnit.y = self.cSelectedUnit.y + iDeltaY
			   
			   if self.cSelectedUnit == self.cObserver:
				  for i in self.lcUnits.values():
					 self.computeDistance(i)
			   else:
				  self.computeDistance(self.cSelectedUnit)
				
		if self.bSelected:
		   self.Refresh()
		   self.Update()
		   sta_globals.GUI.glCanvas.Refresh()
		   self.computeContributions()
			  
		self.lastx, self.lasty = self.x, self.y

#========================================================================
#												 Distance calculation
#========================================================================
	def computeDistance(self,l_cUnit):
		
		fDeltaX = l_cUnit.x - self.cObserver.x
		fDeltaY = l_cUnit.y - self.cObserver.y
		l_cUnit.fDelta = math.sqrt(fDeltaX*fDeltaX + fDeltaY*fDeltaY)
		
	def computeDistances(self):
		for i in self.lcUnits.values():
		   self.computeDistance(i)
	
	def computeContributions(self):
		
		fContributionTotal = 0
		fMinDelta   = self.lThrasholds[0]+1
		self.fMixRatio   = 0
		
		# compute contributions
		for i in self.lcUnits.values():
		  if i.bActive:
			if i.fDelta == 0:
			   i.fContribution = 1
			else:
			   i.fContribution	= 1.0 / (i.fDelta * i.fDelta)
			fContributionTotal = fContributionTotal + i.fContribution
			if i.fDelta < fMinDelta:
			   fMinDelta = i.fDelta
		
		# compute mixing ratio
		
		iVal1 = self.lThrasholds[0]
		iVal2 = self.lThrasholds[-1]
		
		if fMinDelta < iVal1:
			if fMinDelta < iVal2:
			   self.fMixRatio = 1
			else:
			   self.fMixRatio = float(iVal1-fMinDelta)/(iVal1-iVal2)
			  
		# normalize and tune contributions
		for i in self.lcUnits.values():
		   if i.bActive and fContributionTotal>0:
			  i.fContribution =  i.fContribution / fContributionTotal * self.fMixRatio
		   else:
			  i.fContribution = 0
			
		sta_globals.fMixRatio_Project = self.fMixRatio
			 
#========================================================================
#																 OnDraw
#========================================================================

	def OnDraw(self):
		
		if self.bRendering:
			return
		self.glListSetup()
		
		if self.bInit:
		#------------------------------------------ Units list needs to be initialized ---
			 l_lMixerUnits = []
			 for i in sta_globals.lPlugins_Project:
			   l_lMixerUnits.append(i)
			
			 fXMiddle = self.fSizeX/2
			 fYMiddle = self.fSizeY/2
			 
			 fMinX = float(4*self.fSizeX) / 11
			 fMinY = float(4*self.fSizeY) / 11
			 
			 self.cObserver				= sta_gl_mixerunit.ObserverUnit(0,fXMiddle,fYMiddle,"Observer",0)
			 
			 iLen = len(l_lMixerUnits)
			 if iLen != 0:
				fAlpha = float(math.pi * 2) / iLen
				
			 for i in range(iLen):
				fX = int(fXMiddle + fMinX * math.cos(fAlpha*i))
				fY = int(fYMiddle + fMinY * math.sin(fAlpha*i))
				l_sClass	= l_lMixerUnits[i].sClass
				l_sName	 = l_lMixerUnits[i].sName
				l_cPlugin   = l_lMixerUnits[i]
				
				exec('import '+l_sClass)
				l_cUnit = eval(l_sClass+'.'+'MixerUnit(fX,fY,l_sName,l_cPlugin)')
				
				self.lcUnits[l_sClass] = l_cUnit
				
			 sta_globals.lcUnits_Project = self.lcUnits
				
			 self.bInit = False
		#------------------------------------------------------------- List initialized --- 
		
		glTranslatef(0,self.fSizeY,0) 
		glScalef(1,-1,1)
		  
		# Draw observer influence
		self.cObserver.draw_bk(self.lThrasholds)
		
		# Draw units
		for i in self.lcUnits.values():
			i.draw()
		
		# Draw observer
		self.cObserver.draw()
		
		#---------------- End drawing ---
		self.glListRun()
