import wx
import sta_utils
import sta_globals

from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *

#/////////////////////////////////////////////////////////////////////////
#							Mixer Unit
#/////////////////////////////////////////////////////////////////////////

class MixerUnit:
	def __init__(self,l_x,l_y,l_sName,l_cPlugin,*args, **kwds):
		self.x					= l_x		# x coordinate
		self.y					= l_y		# y coordinate
		self.sName				= l_sName	# Display name
		self.cPlugin			= l_cPlugin	 # Associated plugin
		if self.cPlugin != 0:		# Plugin name
			self.sClass			= l_cPlugin.sClass  
		else:
			self.sFilter		= ''
		self.fDelta				= 1		# distance to referennce observer
		self.fContribution		= 0		# contribution to observer image
		self.iFont				= GLUT_BITMAP_8_BY_13
										# the default font							
		#self.fLen = sta_utils.my_glutBitmapLength(self.iFont,self.sName)
		self.fLen = len(self.sName)*8
										# the pixel size of the name		
		self.bActive			= False	# True if the unit is active		
		self.iAttrType			= -1	# -1 - No emlements associated
										#  0 - Version attribute
										#  1 - File attribute
										
		self.iDrawType			= 0		# 0 - squares (up to 9)
										# 1 - vertiocal lines
										# 2 - horizontal lines
										# 3 - horizontal lines with multiple hit indication

#---------------------------------------------------------- Draw name ---
	def drawName(self,x,y,mode):  
	
		# mode = 0 -> Left aligned
		# mode = 1 -> Center aligned
		# mode = 2 -> Right aligned
	
		if mode == 1:
			glRasterPos2f(x-self.fLen/2, y)
		elif mode == 2:
			glRasterPos2f(x-self.fLen, y)
		else:
	 		 glRasterPos2f(x, y)
			 
		for c in self.sName:  
			 glutBitmapCharacter(self.iFont, ord(c))

#-------------------------------------------------------- Draw glyph ---
	def draw(self):		
		if self.bActive:
			#----------------------------------------------- squares ---
			if (self.iDrawType == 0):
				fUnit = float(2*sta_globals.iUnitSize)/3
				iLen = len(self.cPlugin.lIdx)
			
				for i in range(0,3):
					for j in range(0,3):
						k = i*3+j
						if iLen ==0:
							glColor3fv(self.cPlugin.cGUIList.lColors[k])
						else:
							if k<iLen:												  
								l_iIdx = self.cPlugin.lIdx[k]
								lColor = self.cPlugin.cGUIList.lColors[self.cPlugin.cGUIList.dColors[self.cPlugin.lData[l_iIdx]]]
								glColor3fv(lColor)
							else:
								glColor3f(0.75,0.75,0.75)
						glRectf(self.x-sta_globals.iUnitSize+i*fUnit,\
							self.y-sta_globals.iUnitSize+j*fUnit,\
							self.x-sta_globals.iUnitSize+(i+1)*fUnit,\
							self.y-sta_globals.iUnitSize+(j+1)*fUnit)
			#--------------------------------------- vertical lines ---
			elif (self.iDrawType == 1):
				l_bSw = True
			
				iLen = len(self.cPlugin.lIdx)			
				if (iLen == 0):
					iLen = 9
					l_bSw = False
			
				fUnit = float(2*sta_globals.iUnitSize)/iLen
				
				for i in range(0,iLen):
					
					if l_bSw:
						l_iIdx = self.cPlugin.lIdx[i]
						lColor = self.cPlugin.cGUIList.lColors[self.cPlugin.cGUIList.dColors[self.cPlugin.lData[l_iIdx]]]
					else:
						lColor = self.cPlugin.cGUIList.lColors[i] 
					
					glColor3fv(lColor)			   
					glRectf(self.x-sta_globals.iUnitSize+i*fUnit,\
					self.y-sta_globals.iUnitSize,\
					self.x-sta_globals.iUnitSize+(i+1)*fUnit,\
					self.y+sta_globals.iUnitSize)
			#--------------------------------------- horizontal lines ---
			elif (self.iDrawType == 2):
				iLen = len(self.cPlugin.lIdx)
				if iLen > 6:
					iLen = 6
				# draw selected only
				if iLen > 0:
					fUnit = float(2*sta_globals.iUnitSize)/iLen
					
					for i in range(iLen):
						l_iIdx = self.cPlugin.lIdx[i]
						lColor = self.cPlugin.cGUIList.lColors[self.cPlugin.cGUIList.dColors[self.cPlugin.lData[l_iIdx]]]
						glColor3fv(lColor)
						
						glRectf(self.x-sta_globals.iUnitSize,self.y-sta_globals.iUnitSize+i*fUnit,self.x+sta_globals.iUnitSize,self.y-sta_globals.iUnitSize+(i+1)*fUnit)
				# draw all
				else:
					fUnit = float(2*sta_globals.iUnitSize)/6
					for i in range(0,6):
						glColor3fv(sta_globals.lIDColors[i])
						glRectf(self.x-sta_globals.iUnitSize,\
							self.y-sta_globals.iUnitSize+i*fUnit,\
							self.x+sta_globals.iUnitSize,\
							self.y-sta_globals.iUnitSize+(i+1)*fUnit)
							
			#--------------------------------------- horizontal lines with multiple hit indication---
			elif (self.iDrawType == 3):
				iLen = len(self.cPlugin.lIdx)
				if iLen > 0:
					fUnit = float(2*sta_globals.iUnitSize)/iLen
					
					for i in range(iLen):
						l_iIdx = self.cPlugin.lIdx[i]
						lColor = self.cPlugin.cGUIList.lColors[self.cPlugin.cGUIList.dColors[self.cPlugin.lData[l_iIdx]]]
						glColor3fv(lColor)
						
						glRectf(self.x-sta_globals.iUnitSize,self.y-sta_globals.iUnitSize+i*fUnit,self.x+sta_globals.iUnitSize,self.y-sta_globals.iUnitSize+(i+1)*fUnit)
				else:
					glColor3f(0.75,0.75,0.75)
					glRectf(self.x-sta_globals.iUnitSize,self.y-sta_globals.iUnitSize,self.x+sta_globals.iUnitSize,self.y+sta_globals.iUnitSize)
				
				if iLen > 1:
					glColor3f(1,0,0)
					glRectf(self.x-sta_globals.iUnitSize,self.y-sta_globals.iUnitSize,self.x-sta_globals.iUnitSize+5,self.y+sta_globals.iUnitSize)
			
			#------------------------------------------------------------
			glColor3f(0,0.5,0)
			sta_utils.drawRectangle(self.x-sta_globals.iUnitSize,self.y-sta_globals.iUnitSize,self.x+sta_globals.iUnitSize,self.y+sta_globals.iUnitSize,1)
			self.drawName(self.x,self.y-sta_globals.iUnitSize-5,1)
			self.drawMarker()
		
	def drawMarker(self):		 
			
		if (sta_globals.sMarker3 == self.sClass):
			glColor3f(0,0,0.8)
			sta_utils.drawCircle((self.x,self.y),3*(sta_globals.iUnitSize+2),2)
			
		if (sta_globals.sMarker4 == self.sClass):
			glColor3f(1,0.5,0)
			sta_utils.drawCircle((self.x,self.y),3*(sta_globals.iUnitSize+3),2)
			
#=========================================================================
#							Observer unit
#=========================================================================
class ObserverUnit(MixerUnit):
	
	def __init__(self, p_iColor,*args, **kwds):
		MixerUnit.__init__(self, *args, **kwds)
		
		self.iColor = p_iColor
		self.lColors = [((1,0,0),(0.5,0,0)),((0,0.8,0),(0,0.5,0))]

#-------------------------------------------------------- Draw glyph ---	 
	def draw(self):
		
		glColor3fv(self.lColors[self.iColor][0])
		glRectf(self.x-sta_globals.iUnitSize,self.y-sta_globals.iUnitSize,self.x+sta_globals.iUnitSize,self.y+sta_globals.iUnitSize)		  
		glColor3fv(self.lColors[self.iColor][1])
		sta_utils.drawRectangle(self.x-sta_globals.iUnitSize,self.y-sta_globals.iUnitSize,self.x+sta_globals.iUnitSize,self.y+sta_globals.iUnitSize,2)
		
		MixerUnit.draw(self)
		
	def draw_bk(self,lThresholds):
		iLen = len (lThresholds)
		fInc = 0.2 / iLen
		
		for i in range(iLen):
			glColor3f(0.95-i*fInc,0.95-i*fInc,0.95-i*fInc) 
			sta_utils.drawDisk((self.x,self.y),lThresholds[i])
			
# end class
