
import sta_globals
import sta_utils

from sta_gl		import CanvasBase
from OpenGL.GL		import *
from OpenGL.GLUT	import *
from OpenGL.GLU	import *

#/////////////////////////////////////////////////////////////////////////
#												Vertical Metric Canvas
#/////////////////////////////////////////////////////////////////////////

class VerticalMetricCanvas(CanvasBase):

	def __init__(self, parent, *args, **kwds):
		CanvasBase.__init__(self, *args, **kwds)
		
		self.metric				= []			# The normalized metric value to be visualized (value in [0,1])		
		self.mode				= 1				# The meaning of the value (0:none, 1:activity)
		self.display			= 1				# The display mode (i.e. bar chart, graph, color map)
		self.lColors			= []			# List of colors to be used with type 1 metrics
		self.lsNames			= [\
								"None",\
								"Activity",\
								"Text hits",\
								"Similarity"]	# Description of available metric types
		
		#-------------------------------------- # Standard initialization
		self.bUpdate			= True
		
#========================================================================
#														 State update
#========================================================================
	
	#------------------------------------------------- Show nothing ---
	def showNothing(self):
		self.metric		 = []
	#------------------------------------------------- Show commits ---
	def showCommits(self):	
		l_commits		= []
		l_max			= 0
		for i in sta_globals.lSelectedFiles:
			l_len = len(i.lRevs)
			l_commits.append(l_len)
			if l_len > l_max:
				l_max = l_len
		self.metric = []
		if l_max > 0:
			  for i in range(len(l_commits)):
				self.metric.append(float(l_commits[i])/l_max)		  
	#-------------------------------------------- Show creation time ---
	def showHits(self):
		l_commits		= []
		l_max			= 0

		for i in sta_globals.lSelectedFiles:
			l_iHits = 0
			for j in i.lRevs:				
				try:
					if (j.lValues['pextFind'] != -1):
						l_iHits = l_iHits+1
				except:
					pass
			l_commits.append(l_iHits)
			if l_max < l_iHits:
				l_max = l_iHits
		
		self.metric = []
		if l_max > 0:		  
			for i in range(len(l_commits)):
				self.metric.append(float(l_commits[i])/l_max)
		
	#----------------------------------------------- Show similarity ---
	def showSimilarity(self):
		l_records		= []
		l_max			= 0
		
		for i in sta_globals.lSelectedFiles:
			try:
				l_records.append(i.lValues['similarity'])
				if i.lValues['similarity'] > l_max:
					l_max = i.lValues['similarity']
			except:
				l_records.append(0)
				
		self.metric = []
		if l_max > 0:		  
			for i in range(len(l_records)):
				self.metric.append(float(l_records[i])/l_max)	   
			
	#------------------------------------------------ Set metric mode ---
	def show(self,mode):
		self.mode = mode
		if self.mode == 0:				   
			self.showNothing()		   
			return
		if self.mode == 1:
			self.showCommits()
			return
		if self.mode == 2:
			self.showHits()
			return
		if self.mode == 3:
			self.showSimilarity()
			return

	#------------------------------------------------ Get description ---
	def getDescription(self):
		return self.lsNames[self.mode]
		
#========================================================================
#																 OnDraw
#========================================================================
	def RefreshEx(self):
		self.show(self.mode)
		self.Refresh()
		self.Update()
		
	def OnDraw(self):
		
		if self.bRendering:
			return
		self.glListSetup()
		
		glColor3f(1,1,1)
		if len(sta_globals.lSelectedFiles)>0:
			#----------------------------------------- Update configuration ---
			if (self.bUpdate):
				self.show(self.mode)
				self.bUpdate = False
				
			#------------------------------------------- Draw selected files ---
			
			glTranslatef(0,self.size.height,0)
			
			glScalef(1,-sta_globals.fRatioY,1)
			glTranslatef(0,-sta_globals.fOffsetY,0)
			
			fMargin = 1.5
			
			#---------------------------- Bars ---
			if (self.display == 0):
				glColor3f(0.4,0,0)
				yPos = 0
				for i in self.metric:			  
					glRectf(0,yPos,self.size.width*i-fMargin,yPos+1)
					yPos = yPos+1
					
			#--------------------- Rainbow map ---
			elif (self.display == 1):
				yPos = 0
				for i in self.metric:							
					(r,g,b)=sta_utils.getRainbowColor(i)
					glColor3f(r,g,b)
					glRectf(0,yPos,self.size.width-fMargin,yPos+1)
					yPos = yPos+1
			
		self.glListRun()
