import wx
import wx.lib.newevent
import Queue


bDebug = True
"""
bDebug = False
"""



#====================================================
# 								Platform dependent
#====================================================
import sys

sPlatform = sys.platform
sCMCmdPath = ''
if (sPlatform[:3] == 'win'):
	sCopyCmd = 'copy /y'
elif (sPlatform[:5] == 'linux'):
	sCopyCmd = 'cp'
else:
	print 'Unsuported platform'
	sys.exit(1)

#====================================================
# 									License
#====================================================
#--- Product ID
sVersion			= '1.4'
sProductKey			= 'SolidSTA'
sProductName		= 'SolidSTA'
sProductNameLong	= 'Software Trend Analyzer'
sProductWebSite		= 'http://www.solidsourceit.com/products/SolidSTA-software-repository-analysis.html'
sProductEmail		= 'solidsta@solidsourceit.com'
sCopyright			= 'Copyright (c) 2007-2010 SolidSource B.V.'
sKey				= 'KEkwMApOVdkoY0NyeXB0by5QdWJsaWNLZXkuUlNBClJTQW9iagpxAG9xAX1xAyhVAWVxBEw2NTUzN0wKVQFucQVMNjgxMDEyMzAyNTAzNTQ0MjU4MDI2MjI3NTAwMzkzODk0Mzg0MzU4NzE3ODkwNjk0OTkwNzg1MzcyMTE0Nzk2MDMyNzQxNTg0MTY1NTQ0MTQzNTU0MDQxNzQyNjI5NTk2ODIyNzM5MTY4NDcyOTg3Nzc0OTE5NzQ5MTM4NjI4MDI1MzI5MTg2NjU4NjA5MjgzMDY3MzA4NjQ5OUwKdWIucQB0cQEu'
sTitle				= '%s v%s'%(sProductName,sVersion)
dBranding			= {'appnamelong':sProductNameLong,'appnameshort':sProductName,'appid':sProductName,'appversion':sVersion,'copy':sCopyright}

#====================================================
# 								Data Parameters
#====================================================

GUI 			= 0				# The application GUI
STAEvent, EVT_CUSTOM_STA_ID = wx.lib.newevent.NewEvent()
cMainQueue 		= Queue.Queue()
cWorkersQueue	= Queue.Queue()
iUpdateTime		= 0				# Some actions should not be performed if they arrive too soon

sStartDir 		= ''			# Starting folder of the application
sProjectName 	= sProductName
lProjects		= []			# List of available projects

bActionCancel	= False

fileDebug			= 0			# Handler for debugging messages

#DB
sDBPath			= ''			# Current DB

# Files
lFiles 					= []	# List of files in the current project
lSelectedFiles			= []	# List of currently selected files
iSelectedFilesStartTime = 0		# start time for the list of selected files
iSelectedFilesEndTime 	= 0		# end time for the list of selected files
cSelectedFile 			= ''	# Currently selected file
bSelectedFile 			= False	# True if a file is selected
cSelectedFolder			= ''	# Currently selected folder

iStartTime		= 0				# First creation time
iEndTime		= 0				# Last commit time

iProjectStartTime		= 0		# Project start time
iProjectEndTime			= 0		# Project end time

iSelectedFilesStartTime		= 0	# Selected files start time
iSelectedFilesEndTime		= 0 # Selected files end time
iSelectedFilesInterval		= 0 # Selected files interval

# Plugins
lPlugins_Project                = []	# List of available plugins for the selected project
lPlugins_Cluster                = []	# List of available plugins for clustering
lPlugins_MetricGenerator        = []	# List of available plugins for metric generation

lDisplayedFilters_Project		= []	# List of displayed filters for the selected project

dAttrEvolution          		= {}    # Attribute evolution filter list

# Code metrics
lMetrics = []

# Clusters
cClusterEngine = ''				# Current clustering engine

# Selections
bFolderSelection 	= True		# Type of current selection
lSelections			= []		# List of all available file selections in this project

#Sorting operations
lpSortFunction		= []		# List of sorting fucntions
iSortMode			= 1			# Alphabetical order
bSortInvert			= False		# Invert sort order

#====================================================
# 					Similarity analysis parameters
#====================================================

iCommitRadius			= 2*3600	# 2 hour
lChangeImpact			= [1.0,0.8,0.4,0.2,0.1,0.1]		# Impact after 3m, 2m, 1m, 2wk, 1wk, days

#====================================================
# 									Clusters
#====================================================

iStartFocusInterval		= -1
iEndFocusInterval		= -1

iClusterDetailStep		= 2
iClusterDetail			= 12
iClusterSelectedDetail	= 6
iClusterLevel			= 10
iTotalLevels			= 100

def getClusterLevelTableIdx(p_iLevel):
	l_fLayerRatio	= float(iTotalLevels)/iClusterDetail
	l_iLevel		= int(p_iLevel*l_fLayerRatio)
	if (l_iLevel > iTotalLevels-1):
		l_iLevel	= iTotalLevels-1
	return l_iLevel

#====================================================
#									SCM Engine
#====================================================

bFullVersionInfo	= False

cSTAPrj 			= 0		# Currently loaded project
sSCMRoot			= ''	# Root used in SCM operations

lsContentExtensions = ['c','cs','cc','cpp','cxx','c++','h','hh','hpp','hxx','h++','j','js','jav','java','py','pl','php','txt','htm','html']

#---- SVN
cSVNClient			= ''		# SVN client
iSVNRetries			= 1			# Number of retries upon failure
iSVNSleep			= 5 		# Number of seconds to wait upon failure

#====================================================
# 					Project display parameters
#====================================================

fRatioX		= 1
fOffsetX	= 0
fSizeX		= 0
fUnitX		= 1
fZoomX		= 1

fRatioY		= 1
fOffsetY	= 0
fSizeY		= 0
fUnitY		= 1
fZoomY		= 1
fUnitFile	= 1

iScrollResolution	= 1000
iScrollSizeX		= iScrollResolution
iScrollSizeY		= iScrollResolution
iScrollPosX			= 0
fScrollRatioX		= 1
fScrollRatioY		= 1
iScrollPosY			= 0

fFontWidth			= 0
fFontHeight			= 0

#------------------------------------------------
# 							Texture markers
#------------------------------------------------

iMarker3Size		= 3

fMarkerRatio		= 0.6	# maximum marker contribution to marker value
fMarkerThreshold	= 8		# zoom level after which the marker is enabled

sMarkerName			= "cfg/img/marker1.raw"

fMarker4Detail		= 40	# Initial level of detail
fMarker4Intensity	= 0.005	# Initial intensity
iMarker3Size		= 3

sMarker3			= ''	# Display marker 3
sMarker4			= ''	# Display marker 4

iMode3				= 0	# Display mode marker 3
iMode4				= 0	# Display mode marker 4

#====================================================
# 						Visualization Parameters
#====================================================

#---- Cushions
iNrPixelsClusterEdge= 15	# the number of pixel in the edge of a plateau cushion for clusters

cMainCushions		= '' # Main panel cushions
cHorizontalCushions	= '' # Horizontal metric panel cushions
cClusterCushions	= '' # Cluster panel cushions

iCushionLight		= 109
fCushionHeight		= 0.15

#---- Blender units
iUnitSize			= 10	# Size of the view mode unit in the blender view
fMixRatio_Project	= 0     # Mixer ratio for projects
lcUnits_Project		= 0     # Mixer units for projects

#---- Labels
bFileLabels			= True
sMonths				= [' ','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']

bAttrLabels         = True  # Show attribute labels
bAttrGrid           = True  # Show attribute time grid
bAttrTimeLabels     = True  # Show attribute time labels
bAttrVScale         = True  # Show attribute vertical scale
bAttrNameLabel      = True  # Show attribute list name

#---- Log Command Animation Engine
sConnectionBmp			= "cfg/img/connection2.bmp"
bConnectionOpen			= False	# Used in connection animation

#---- File list images
sFileList0 = "cfg/img/empty.bmp"
sFileList1 = "cfg/img/info1.bmp"
sFileList2 = "cfg/img/info2.bmp"
sFileList3 = "cfg/img/root.bmp"
sFileList4 = "cfg/img/folder.bmp"

#---- Snapshot images
lPixelsEvolution 	= []	# The evolution image
iHorizontalBar		= 16	# Height of the horizontal bar
lPixelsHorizontal	= []	# The horizontal bar image

#---- Cross transactions
CT_iLevel			= 15	# Initially more than 15 commits
CT_dTintedHash		= {}	# List of hashes of messages that have to be removed
CT_dMessageLog 		= {}	# Records the number of occurences of one hash
CT_dMessageID 		= {}	# Get the source of one hash

#====================================================
# Color Maps
#====================================================

lBiColorMap = [	(0.20,0.90,0.00),(0.60,0.20,0.00),(0.90,0.00,0.60),\
				(0.75,0.75,1.00),(1.00,1.00,1.00),(1.00,0.75,0.75),\
				(1.00,0.75,0.75),(1.00,1.00,1.00),(0.75,0.75,1.00)]

#------------------------------------ User colors ---
lIDColors = [(1.00, 0.50, 0.50),\
	(0.00, 1.00, 0.50),\
	(0.50, 1.00, 1.00),\
	(0.00, 0.50, 1.00),\
	(1.00, 0.50, 0.75),\
	(0.80, 0.20, 0.20),\
	(1.00, 1.00, 0.00),\
	(0.50, 1.00, 0.00),\
	(0.00, 1.00, 0.25),\
	(0.00, 0.50, 0.75),\
	(0.50, 0.50, 0.75),\
	(1.00, 0.00, 1.00),\
	(0.50, 0.25, 0.25),\
	(1.00, 0.50, 0.25),\
	(0.00, 1.00, 0.00),\
	(0.00, 0.50, 0.50),\
	(1.00, 0.50, 1.00),\
	(0.00, 0.25, 0.50),\
	(0.50, 0.50, 1.00),\
	(0.50, 0.00, 0.25),\
	(1.00, 0.00, 0.50),\
	(0.00, 1.00, 1.00),\
	(0.50, 0.00, 0.00),\
	(1.00, 0.50, 0.00),\
	(0.00, 0.50, 0.00),\
	(0.00, 0.50, 0.25),\
	(0.00, 0.00, 1.00),\
	(0.50, 1.00, 0.50),\
	(0.00, 0.00, 0.62),\
	(0.50, 0.00, 0.50),\
	(0.50, 0.00, 1.00),\
	(0.25, 0.00, 0.00),\
	(0.50, 0.25, 0.00),\
	(0.00, 0.25, 0.00),\
	(0.00, 0.25, 0.25),\
	(0.00, 0.00, 0.50),\
	(0.00, 0.00, 0.25),\
	(0.25, 0.00, 0.25),\
	(0.25, 0.00, 0.50),\
	(1.00, 1.00, 0.50),\
	(0.50, 0.50, 0.00),\
	(0.50, 0.50, 0.25),\
	(0.25, 0.50, 0.50),\
	(1.00, 1.00, 1.00),\
	(0.00, 1.00, 0.50),\
	(0.50, 1.00, 1.00),\
	(0.00, 0.50, 1.00),\
	(1.00, 0.50, 0.75),\
	(0.80, 0.20, 0.20),\
	(1.00, 1.00, 0.00),\
	(0.50, 1.00, 0.00),\
	(0.00, 1.00, 0.25),\
	(0.00, 0.50, 0.75),\
	(0.50, 0.50, 0.75),\
	(1.00, 0.00, 1.00),\
	(0.50, 0.25, 0.25),\
	(1.00, 0.50, 0.25),\
	(0.00, 1.00, 0.00),\
	(0.00, 0.50, 0.50),\
	(1.00, 0.50, 1.00),\
	(0.00, 0.25, 0.50),\
	(0.50, 0.50, 1.00),\
	(0.50, 0.00, 0.25),\
	(1.00, 0.00, 0.50),\
	(0.00, 1.00, 1.00),\
	(0.50, 0.00, 0.00),\
	(1.00, 0.50, 0.00),\
	(0.00, 0.50, 0.00),\
	(0.00, 0.50, 0.25),\
	(0.00, 0.00, 1.00),\
	(0.50, 1.00, 0.50),\
	(0.00, 0.00, 0.62),\
	(0.50, 0.00, 0.50),\
	(0.50, 0.00, 1.00),\
	(0.25, 0.00, 0.00),\
	(0.50, 0.25, 0.00),\
	(0.00, 0.25, 0.00),\
	(0.00, 0.25, 0.25),\
	(0.00, 0.00, 0.50),\
	(0.00, 0.00, 0.25),\
	(0.25, 0.00, 0.25),\
	(0.25, 0.00, 0.50),\
	(1.00, 1.00, 0.50),\
	(0.50, 0.50, 0.00),\
	(0.50, 0.50, 0.25),\
	(0.25, 0.50, 0.50),\
	(1.00, 0.50, 0.50),\
	(0.00, 1.00, 0.50),\
	(0.50, 1.00, 1.00),\
	(0.00, 0.50, 1.00),\
	(1.00, 0.50, 0.75),\
	(0.80, 0.20, 0.20),\
	(1.00, 1.00, 0.00),\
	(0.50, 1.00, 0.00),\
	(0.00, 1.00, 0.25),\
	(0.00, 0.50, 0.75),\
	(0.50, 0.50, 0.75),\
	(1.00, 0.00, 1.00),\
	(0.50, 0.25, 0.25),\
	(1.00, 0.50, 0.25),\
	(0.00, 1.00, 0.00),\
	(0.00, 0.50, 0.50),\
	(1.00, 0.50, 1.00),\
	(0.00, 0.25, 0.50),\
	(0.50, 0.50, 1.00),\
	(0.50, 0.00, 0.25),\
	(1.00, 0.00, 0.50),\
	(0.00, 1.00, 1.00),\
	(0.50, 0.00, 0.00),\
	(1.00, 0.50, 0.00),\
	(0.00, 0.50, 0.00),\
	(0.00, 0.50, 0.25),\
	(0.00, 0.00, 1.00),\
	(0.50, 1.00, 0.50),\
	(0.00, 0.00, 0.62),\
	(0.50, 0.00, 0.50),\
	(0.50, 0.00, 1.00),\
	(0.25, 0.00, 0.00),\
	(0.50, 0.25, 0.00),\
	(0.00, 0.25, 0.00),\
	(0.00, 0.25, 0.25),\
	(0.00, 0.00, 0.50),\
	(0.00, 0.00, 0.25),\
	(0.25, 0.00, 0.25),\
	(0.25, 0.00, 0.50),\
	(1.00, 1.00, 0.50),\
	(0.50, 0.50, 0.00),\
	(0.50, 0.50, 0.25),\
	(0.25, 0.50, 0.50),\
	(1.00, 1.00, 1.00),\
	(0.00, 1.00, 0.50),\
	(0.50, 1.00, 1.00),\
	(0.00, 0.50, 1.00),\
	(1.00, 0.50, 0.75),\
	(0.80, 0.20, 0.20),\
	(1.00, 1.00, 0.00),\
	(0.50, 1.00, 0.00),\
	(0.00, 1.00, 0.25),\
	(0.00, 0.50, 0.75),\
	(0.50, 0.50, 0.75),\
	(1.00, 0.00, 1.00),\
	(0.50, 0.25, 0.25),\
	(1.00, 0.50, 0.25),\
	(0.00, 1.00, 0.00),\
	(0.00, 0.50, 0.50),\
	(1.00, 0.50, 1.00),\
	(0.00, 0.25, 0.50),\
	(0.50, 0.50, 1.00),\
	(0.50, 0.00, 0.25),\
	(1.00, 0.00, 0.50),\
	(0.00, 1.00, 1.00),\
	(0.50, 0.00, 0.00),\
	(1.00, 0.50, 0.00),\
	(0.00, 0.50, 0.00),\
	(0.00, 0.50, 0.25),\
	(0.00, 0.00, 1.00),\
	(0.50, 1.00, 0.50),\
	(0.00, 0.00, 0.62),\
	(0.50, 0.00, 0.50),\
	(0.50, 0.00, 1.00),\
	(0.25, 0.00, 0.00),\
	(0.50, 0.25, 0.00),\
	(0.00, 0.25, 0.00),\
	(0.00, 0.25, 0.25),\
	(0.00, 0.00, 0.50),\
	(0.00, 0.00, 0.25),\
	(0.25, 0.00, 0.25),\
	(0.25, 0.00, 0.50),\
	(1.00, 1.00, 0.50),\
	(0.50, 0.50, 0.00),\
	(0.50, 0.50, 0.25),\
	(0.25, 0.50, 0.50),\
	(1.00, 0.00, 0.00)]
