import sta_globals
import sta_utils
import pysqlite2.dbapi2 as sqlite

import wx

#///////////////////////////////////////////////////////////////////////////////
#															   Plugin Class
#///////////////////////////////////////////////////////////////////////////////
class Plugin:
	def __init__(self,*args,**kwds):
		self.lData				= []		# List of item strings for current project
		self.lIdx				= []		# List of selected indexes
		self.bSelected			= False		# True if items are selected
		self.sClass				= 'My file'	# Name of the plugin file
		self.sMetricID			= 'MVAL'	# Identifier to store the processed metric (to be visualized) internaly.
		self.sName				= 'My name'	# Name to display
		self.lTables			= []		# List of tables used by the plugin (use this to perform enable check)
		self.cGUIList			= 0			# The GUI list
		self.bGUIDisplayed		= False		# The GUI is displayed
		self.cGUIMaster			= 0			# GUI master
		self.cSizer				= 0			# Sizer used to show / hide list
		self.iMetricType		= 0			# 0 = commit plugin, 1 = file plugin
		self.sVersion			= '1.0'		# The current version of the filter
		self.bHasMetricValue	= False		# True if it can return a metric value
		self.bHasDecay			= False		# True if commit influence is decaying (e.g. author knowledge)

#===============================================================================
#																 Data metrics
#===============================================================================

	def clearSelection(self):
		self.lIdx			= []
		self.bSelected 		= False

	#--------------------------------------------------- loadMetric ---
	# TODO: Overwrite this with custom implementation
	def loadMetric(self):
		pass
		#TODO:  Generate the metric to be visualized
		#	   The metric should be added to each commit or file in the special lAttr or lValue fields
		#	   The nongraphical plugins do not populate GUI lists

	#------------------------------------------------- unloadMetric ---
	# TODO (optional): Overwrite this with custom implementation
	def unloadMetric(self):

		#--------------------- Revision filter
		if (self.iMetricType == 0):
			for i in sta_globals.lFiles:
				for j in i.lRevs:
					try:
						del j.lValues[self.sClass]
						del j.lValues[self.sMetricID]
					except:
						pass
		#------------------------- File filter
		elif (self.iMetricType == 1):
			for i in sta_globals.lFiles:
				if i.iType == 0:
					try:
						del i.lValues[self.sClass]
						del i.lValues[self.sMetricID]
					except:
						pass
		#--------------------------------------

		self.clearFilterGUI()
		self.lData			= []
		self.clearSelection()

	#-------------------------------------------------- reloadMetric ---
	def reloadMetric(self):
		self.unloadMetric()
		self.loadMetric()

	#------------------------------------------------ getMetricValue ---
	def getMetricValue(self,p_cElement):
		iReturn = 0
		iError	= 0
		try:
			if self.bHasMetricValue:
				if (p_cElement.lValues[self.sMetricID] != -1) and (p_cElement.lValues[self.sClass] != -1) and (p_cElement.lValues[self.sMetricID] is not None):
					iReturn = p_cElement.lValues[self.sMetricID]
				else:
					iReturn = 0

					# This causes files without the metric to be skipped
					iError = 1
			else:
				if p_cElement.lValues[self.sClass] != -1:
					iReturn = 1
				else:
					iReturn = 0
		except:
			iError = 1
		return iReturn,iError

	#----------------------------------------------- getDecayedValue ---
	# TODO: Overwrite this with custom implementation
	def getDecayedValue(self,p_iTime):
		return 0

#===============================================================================
#																 Color values
#===============================================================================

#------------------------------------------------- Get element color ---
	def getElementColor(self,cCommit,cFile):

		try:
			#------------------------------- Version element ---
			if self.iMetricType == 0:
				iValueIndex = cCommit.lValues[self.sClass]

			#--------------------------------- File element ---
			elif self.iMetricType == 1:
				iValueIndex = cFile.lValues[self.sClass]
		except:
			iValueIndex = -1
		#--------------------------------------------------
		lColor = (1.00, 0.00, 0.00)

		if (iValueIndex>=0):

			if len(self.lData) == 0:
				return (0.75, 0.75, 0.75)

			try:
				cValue 		= self.lData[iValueIndex]				# Get real value
				iColorIndex	= self.cGUIList.dColors[cValue]			# Get color index based on real value
				lColor 		= self.cGUIList.lColors[iColorIndex]	# Get color based on color index
			except:
				print "Invalid color index, metric id:", iValueIndex

		elif iValueIndex == -1:
			lColor = (0.75, 0.75, 0.75)
		elif iValueIndex == -2:
			lColor = (1.00, 0.00, 0.00)
		elif iValueIndex == -3:					# Used for file evolution in empty places
			lColor = (1.00, 1.00, 1.00)

		return lColor

#===============================================================================
#																 GUI support
#===============================================================================

	#----------------------------------- Refresh filter title ---
	def Refresh(self):
	  if self.cGUIList.sMetric == '':
	    self.g_txtMetric.SetLabel('')
	  else:
	    self.g_txtMetric.SetLabel('  ('+self.cGUIList.sMetric+')')

	#----------------------------------------- buildFilterGUI ---
	# TODO: Overwrite this with custom implementation

	def buildFilterGUI(self,pMasterGUI):
		print "... My Plugin"
		self.cGUIMaster = pMasterGUI

	def doBindings(self):
		self.cGUIList.Bind(wx.EVT_MENU,self.cbNewSelectionFromMatching, id=218)

	#------------------------------------------ showFilterGUI ---
	def showFilterGUI(self,p_bState):
		if p_bState:
			if not self.bGUIDisplayed:
				sta_globals.lDisplayedFilters_Project.append(self)
				l_iIdx = sta_globals.lPlugins_Project.index(self)
				self.cGUIMaster.cMenuFilters.Append(112*10+l_iIdx,self.sName)
		else:
			if self.bGUIDisplayed:
				sta_globals.lDisplayedFilters_Project.remove(self)
				l_iIdx = sta_globals.lPlugins_Project.index(self)
				self.cGUIMaster.cMenuFilters.Remove(112*10+l_iIdx)

		self.bGUIDisplayed = p_bState
		self.cGUIMaster.cListsSizer_Project.Show(self.cSizer,p_bState)

		if self.cGUIList.cAttrEvolution != 0:
			self.cGUIList.cAttrEvolution.Show(p_bState)

		self.cGUIMaster.cbFilterSize_aux()

	#---------------------------------------- enableFilter ---
	def enableFilter(self):
		l_sw = True

		# Verify if database exists
		if not sta_utils.isValidDB(sta_globals.sDBPath):
			l_sw = False
		# Verify if table exists
		else:
			cDB = sqlite.connect(sta_globals.sDBPath)
			cCursorDB = cDB.cursor()
			for i in self.lTables:
				if not sta_utils.isValidTable(cCursorDB,i):
					l_sw = False
					break
			cCursorDB.close()
			cDB.close()

		# Disable entry in plugins list if metric not available
		self.enableFilter_aux(l_sw)

		return l_sw

	def enableFilter_aux(self,l_sw):
		if not l_sw:
			self.unloadMetric()				# Unload metric
			self.showFilterGUI(False)		# Hide GUI
			sta_globals.lcUnits_Project[self.sClass].bActive = False
											# Icon in the preset controller
											# Entry in the filters list
			i = self.cGUIMaster.g_lFilters_Project.FindString(self.sName)
			if i != wx.NOT_FOUND:
				self.cGUIMaster.g_lFilters_Project.Delete(i)
		else:
			i = self.cGUIMaster.g_lFilters_Project.FindString(self.sName)
			if i == wx.NOT_FOUND:
				self.cGUIMaster.g_lFilters_Project.Append(self.sName)

	#----------------------------------- getSelectedIndexes ---
	# TODO: Overwrite this with custom implementation
	def getSelectedIndexes(self):
		pass

	#----------------------------------------- cbListSelect ---
	def cbListSelect(self,evt):

		if not self.bGUIDisplayed:
			return

		# Get selected indexes
		self.getSelectedIndexes()

		# Mark selected authors in value fields
		self.cbListSelect_aux(sta_globals.lSelectedFiles)

		# Update canvases
		self.updateCanvases()


	def cbNewSelectionFromMatching(self, event):
		self.getSelectedIndexes()

		# Trigger a selection update for all fields, this will set the proper classes for all files
		self.cbListSelect_aux(sta_globals.lFiles)

		sta_globals.lSelectedFiles = []


		#------------------------------- Version element ---
		if self.iMetricType == 0:
			for i in sta_globals.lFiles:
				bFound = False
				for j in i.lRevs:
					if self.isItemSelected(j):
						bFound = True;
						break

				if bFound:
					sta_globals.lSelectedFiles.append(i)

		#--------------------------------- File element ---
		elif self.iMetricType == 1:
			for i in sta_globals.lFiles:
				if i.lValues[self.sClass] > -1:
					sta_globals.lSelectedFiles.append(i)

		if len(self.lIdx) == 0:
			sta_globals.lSelectedFiles = sta_globals.lFiles

		sta_globals.GUI.HideFilterMetrics()
		sta_globals.GUI.mainFrame.g_listFiles.Unselect()
		sta_globals.GUI.mainFrame.g_listSelections.SetSelection(wx.NOT_FOUND)
		sta_globals.bSelectedFile = False
		sta_globals.GUI.UpdateSelectedFiles(False,False)

	#---------------------------------------- isItemSelected ---
	def isItemSelected(self,p_cItem):
		try:
			if p_cItem.lValues[self.sClass] >-1:
				return True
		except:
			pass
		return False

	#---------------------------------------- clearFilterGUI ---
	def clearFilterGUI(self):
		self.cGUIList.HideMetric(0)
		self.cGUIList.Clear()

	#---------------------------------------- updateCanvases ---
	def updateCanvases(self):
		sta_globals.GUI.glCanvas.RefreshEx()
		sta_globals.GUI.glVerticalCanvas.RefreshEx()
		sta_globals.GUI.glMixerCanvas_Project.RefreshEx()
		if self.cGUIList.cAttrEvolution != 0:
			self.cGUIList.cAttrEvolution.g_GLPanel.RefreshEx()

#===============================================================================
#																	 Utils
#===============================================================================

#///////////////////////////////////////////////////////////////////////////////
def getPluginByName(p_lPlugins,p_sName):
	for i in range(len(p_lPlugins)):
	  if p_lPlugins[i].sName == p_sName:
	    return p_lPlugins[i]
	return 0

def getPluginByClass(p_lPlugins,p_sClass):
	for i in range(len(p_lPlugins)):
	  if p_lPlugins[i].sClass == p_sClass:
	    return p_lPlugins[i]
	return 0