import wx
import sta_metricgenerator
import os
import os.path
import subprocess
import sta_utils
import sta_globals
import time
import pysqlite2.dbapi2 as sqlite
import sys
import difflib

	# EXPLANATION
	# This is an example and code template for building metric calculators

	# EXPLANATION
	# Markers like this are used in the source code of this template to indicate the places
	# that need to be modified when implementing a new metric calculator. The used markers are:
	# EXPLANATION	: no action required. This is only information to help understanding the code
	# TEMPLATE 		: the marked code needs to be updated with calculator specific data.
	# CODE			: the marked code needs to be replaced with calculator specific one.
	# MULTI			: the marked code needs to be augmented only when more tables are generated.

#===============================================================================
#													 Lines of text calculator
#===============================================================================
class MetricGenerator(sta_metricgenerator.MetricGenerator):
	def __init__(self,*args, **kwds):

		sta_metricgenerator.MetricGenerator.__init__(self,*args, **kwds)
		# TEMPLATE
		#----------------------------------------
		self.sName				= 'Reuse estimator'				# Metric name (to display in the calculators list)
		self.sAuthor			= 'SolidSource'					# Developer of this metric calculator
		self.sVersion			= '1.0'							# Version
		self.sID				= 'reuse'							# unique ID to be used during processing
		self.sInfo		= '<strong>Description:</strong><br />'	# Short description for the calculator
		self.sInfo		= self.sInfo + 'Computes number of lines of text in a file that have been added/deleted/modified with respect to a previous snapshot.<br /><br />'

		self.sInfo		= self.sInfo + '<strong>Requires:</strong><br />'
		self.sInfo		= self.sInfo + 'Source code of files.<br /><br />'

		self.sInfo		= self.sInfo + '<strong>Output metrics:</strong><br />'
		self.sInfo		= self.sInfo + 'Number of added/deleted/modified lines'

		self.sExtensionsList	= ['c','cc','cpp','cxx','c++','cs','h','hh','hpp','hxx','h++','cs','j','js','jav','java','py','pl','php','htm','html','txt']
																# List of files extensions on which this calculatro can be applied
																# If file type independent, leave this list empty
		# MULTI
		#----------------------------------------
		self.sTableID			= 'M_SS2010052801'				# Unique ID for the generated metrics table
		self.sTableName			= 'Reuse'						# Name of generated metrics table (to display in the Calculated metrics list)
		self.iType				= 1								# Metric type: 0 - file , 1 - version
		self.sTableDescription	= 'Version metric.<br />Gives number of lines of text added/deleted/modified between two snapshots'
																# Short description for the computed metrics(to be displayed in the info panel)
		#----------------------------------------
		# END MULTI
		# END TEMPLATE

		# EXPLANATION:
		# sTableID, sTableName, iType and sTableDescription are specific to each generated metrics table in the DB.
		# When more tables are generated by the calculator, copies of each of these variables needs to be made
		# for each table, and need to be handled in the code in the places indicated by the #MULTI marker

#===============================================================================
#																	 Generate
#===============================================================================

	def generate_TFS(self, p_cCursorDB):
		#--------------------------- Task folders ---
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/taskbuffer/"+self.sID
		if not os.path.exists(l_sPath):
			os.makedirs(l_sPath)
		l_sDestPath = l_sPath+"/content.dat"

		for l_cFile in sta_globals.lSelectedFiles:
			sta_globals.GUI.MainThreadExec('self.cbGeneratorProgressUpdate()')

			#--- Check if cancel pressed
			if sta_globals.GUI.bMetricCancel:
				break

			#--- Skip unsupported files
			l_sFile,l_sExtension = os.path.splitext(l_cFile.sPath)
			if (l_sExtension != ''):
				l_sExtension = l_sExtension[1:]
			l_sExtension = l_sExtension.lower()

			if not((len(self.sExtensionsList)==0) or (l_sExtension in self.sExtensionsList)):
				continue

			zipFile = sta_globals.cSTAPrj.storagePath()+"/extra/files/"+str(l_cFile.iDBid)+".zip"
			if not os.path.exists(zipFile):
				continue

			try:
				versions = sta_utils.listArchive(zipFile)
			except:
				continue

			l_cCommit1 = None
			for l_cCommit2 in l_cFile.lRevs:

				if sta_globals.GUI.bMetricCancel:
					break

				if l_cCommit2.sID not in versions:
					continue

				if l_cCommit1 is None:
					l_cCommit1 = l_cCommit2

					try:
						l_sContents = sta_utils.readFile(zipFile, l_cCommit1.sID)
						l_lContent1 = l_sContents.split('\n')
					except:
						l_lContent1 = []

					continue

				try:
					l_sContents = sta_utils.readFile(zipFile, l_cCommit2.sID)
					l_lContent2 = l_sContents.split('\n')
				except:
					l_lContent2 = []

				if not self.calculated(l_cCommit2, p_cCursorDB):
					self.calculateDiff(l_cCommit2, l_lContent1, l_lContent2, p_cCursorDB)

				l_cCommit1 = l_cCommit2
				l_lContent1 = l_lContent2


	def generate_aux(self,p_sSrcArchive1,p_sSrcArchive2,p_iTime1,p_iTime2,p_cCursorDB):
		#--------------------------- Task folders ---
		l_sPath = sta_globals.cSTAPrj.storagePath()+"/taskbuffer/"+self.sID
		if not os.path.exists(l_sPath):
			os.makedirs(l_sPath)
		l_sDestPath = l_sPath+"/content.dat"

		l_lFiles1 = sta_utils.listArchive(p_sSrcArchive1)
		l_lFiles2 = sta_utils.listArchive(p_sSrcArchive2)

		#--------------------------- Generate metrics for all files ---
		# EXPLANATION
		# The way in which a metric is computed can depend very much on the specific calculator.
		# In most cases metrics are calculated incrementaly, taking into account only new files.
		# In such a cese there are three steps to be performed:
		#		- test whether the metric is already computed
		#		- compute the metric by interpreting the information contained in the snapshot
		#		- save the metric in the DB for the corresponding revision

		for l_cFile in sta_globals.lSelectedFiles:

			sta_globals.GUI.MainThreadExec('self.cbGeneratorProgressUpdate()')

			#--- Check if cancel pressed
			if sta_globals.GUI.bMetricCancel:
				break

			sta_globals.GUI.MainThreadExec('self.logCommand(" - "+$STA$+"\\n")',lParams=[l_cFile.sName])

			#--- Skip non-existing files
			l_sFileName = str(l_cFile.iDBid)
			if ((l_sFileName not in l_lFiles1) and (l_sFileName not in l_lFiles2)):
				continue

			#--- Skip unsupported files
			l_sFile,l_sExtension = os.path.splitext(l_cFile.sPath)
			if (l_sExtension != ''):
				l_sExtension = l_sExtension[1:]
			l_sExtension = l_sExtension.lower()

			if not((len(self.sExtensionsList)==0) or (l_sExtension in self.sExtensionsList)):
				continue

			#--- Get snapshot revision
			# First
			if (p_iTime1 > l_cFile.iTime) and (l_cFile.iStatus != 0):
				continue
			else:
				l_cCommit1 = 0

			for l_cRev in l_cFile.lRevs:	# Find first revision before snapshot
				if (l_cRev.iTime <= p_iTime1):
					l_cCommit1 = l_cRev
				else:
					break

			if len(l_cFile.lRevs) == 0:
				continue

			if (p_iTime2 < l_cFile.lRevs[0].iTime):
				continue
			else:
				l_cCommit2 = 0

			for l_cRev in l_cFile.lRevs:	# Find first revision before snapshot
				if (l_cRev.iTime <= p_iTime2):
					l_cCommit2 = l_cRev
				else:
					break

			if self.calculated(l_cCommit2, p_cCursorDB):
				continue

			try:
				l_sContents = sta_utils.readFile(p_sSrcArchive1,l_sFileName)
				l_lContent1 = l_sContents.split('\n')
			except:
				l_lContent1 = []

			try:
				l_sContents = sta_utils.readFile(p_sSrcArchive2,l_sFileName)
				l_lContent2 = l_sContents.split('\n')
			except:
				l_lContent2 = []

			self.calculateDiff(l_cCommit2, l_lContent1, l_lContent2, p_cCursorDB)

	def calculated(self, l_cCommit, p_cCursorDB):
		sCmd = "select ID from "+self.sTableID+" where ID="+str(l_cCommit.iDBid)
		p_cCursorDB.execute(sCmd)
		return p_cCursorDB.fetchone() != None

	def calculateDiff(self,l_cCommit,l_lContent1,l_lContent2,p_cCursorDB):
			l_iADD = 0
			l_iDEL = 0
			l_iMOD = 0

			l_iLen1 = len(l_lContent1)
			l_iLen2 = len(l_lContent2)

			if l_iLen1 == 0 and l_iLen2 == 0:
				return
			elif l_iLen1 == 0:
				l_iADD = l_iLen2
			elif l_iLen2 == 0:
				l_iDEL = l_iLen1
			else:
				l_iLocalAdd = 0
				l_iLocalDel = 0
				for sLine in difflib.unified_diff(l_lContent1, l_lContent2):
					if sLine.startswith('@@'):
						if (l_iLocalAdd == l_iLocalDel):
							l_iMOD += l_iLocalAdd
						else:
							l_iADD += l_iLocalAdd
							l_iDEL += l_iLocalDel
						l_iLocalAdd = 0
						l_iLocalDel = 0
					elif sLine.startswith('-'):
						l_iLocalDel += 1
					elif sLine.startswith('+'):
						l_iLocalAdd += 1
				if (l_iLocalAdd == l_iLocalDel):
					l_iMOD += l_iLocalAdd
				else:
					l_iADD += l_iLocalAdd
					l_iDEL += l_iLocalDel

			if (l_iMOD>0):
				l_iMOD -= 1

			# TEMPLATE
			# MULTI
			#----------------------------------------
			# save metric in DB

			sCmdRoot = "insert into "+self.sTableID+"(ID,ADDline,DELline,MODline) values (%s,%s,%s,%s)"
			sParam = [l_cCommit.iDBid,l_iADD,l_iDEL,l_iMOD]
			sCmd = sCmdRoot%tuple(sParam)
			p_cCursorDB.execute(sCmd)

			#----------------------------------------
			# END MULTI
			# END TEMPLATE

	#-------------------------------------------------------------------------------
	#																Main entry point
	#-------------------------------------------------------------------------------
	def generate(self,p_sDBPath):

		if not sta_utils.isValidDB(p_sDBPath):
			sta_globals.GUI.MainThreadExec('self.logCommand(" ERROR: no history information found\\n")')
			sta_globals.GUI.MainThreadExec('self.postGenerator()')
			return

		cDB = sqlite.connect(p_sDBPath)
		cCursorDB = cDB.cursor()

		# TEMPLATE
		# MULTI
		#----------------------------------------
		# Action:
		#	- Replace '(ID integer primary key, LOT integer)' with specific table structure. ID column needs to be alsways present
		#	- In case remove/clean dependencies exist between more tables, they need to be specified in the Dependenices
		#		column of the Metrics table as a string containing sTableIDs separated by ':'. In this example there are no
		#		dependencies (i.e., when deleting the generated table, no other tables need to be also removed
		#		in order to keep the DB clean). When dependencies exist, however, one need to replace the null in
		#		('%s','%s',%s,'%s',null) with '%s' and add the appropriate dependencies string to the sParam list
		#	- Repeat the code snipet for all generated tables (if more)

		if not (sta_utils.isValidTable(cCursorDB,self.sTableID)):
			sCmd = "create table "+self.sTableID+"(ID integer primary key, ADDline integer, DELline integer, MODline integer)"
			cCursorDB.execute(sCmd)

			sCmdRoot = "insert into Metrics(ID,Name,Type,Description,Dependencies) values ('%s','%s',%s,'%s',null)"
			sParam = [self.sTableID,self.sTableName,str(self.iType),self.sTableDescription]
			sCmd = sCmdRoot%tuple(sParam)
			cCursorDB.execute(sCmd)
		#----------------------------------------
		# END MULTI
		# END EMPLATE

		if sta_globals.cSTAPrj.sType == 'TFS':
			self.generate_TFS(cCursorDB)
		else:
			# Calculate metrics for all snapshots
			l_sSrcArchiveBase	= sta_globals.cSTAPrj.storagePath()+"/extra/snapshots"

			for l_iSnapshot in range(len(sta_globals.cSTAPrj.lSnapshots)-1):

				l_cSnapshot1 = sta_globals.cSTAPrj.lSnapshots[l_iSnapshot]
				l_cSnapshot2 = sta_globals.cSTAPrj.lSnapshots[l_iSnapshot+1]

				if sta_globals.GUI.bMetricCancel:
					sta_globals.GUI.bMetricCancel = False
					break

				# First snapshot
				l_sDate = time.strftime("%Y%m%d_%H%S%M",time.gmtime(l_cSnapshot1[0]))
				l_sSrcArchive = l_sSrcArchiveBase+"/"+l_sDate+".zip"
				l_sSrcArchive1 = l_sSrcArchive.replace('\\','/')

				# Second snapshot
				l_sDate = time.strftime("%Y%m%d_%H%S%M",time.gmtime(l_cSnapshot2[0]))
				l_sSrcArchive = l_sSrcArchiveBase+"/"+l_sDate+".zip"
				l_sSrcArchive2 = l_sSrcArchive.replace('\\','/')

				self.generate_aux(l_sSrcArchive1,l_sSrcArchive2,l_cSnapshot1[0],l_cSnapshot2[0],cCursorDB)

				sta_globals.GUI.MainThreadExec('self.logCommand("Snapshot: "+$STA$+" generation completed\\n")',lParams=[l_cSnapshot2[1]])

		# close database
		cDB.commit()
		cCursorDB.close()
		cDB.close()

		sta_globals.GUI.MainThreadExec('self.UpdateFiltersList()')
		sta_globals.GUI.MainThreadExec('self.logCommand("Finished: "+$STA$+" generation\\n")',lParams=[self.sName])
		sta_globals.GUI.MainThreadExec('self.postGenerator()')
