import wx
import string
import os
import os.path
import math
import time
import calendar
import zipfile
import hashlib
from OpenGL.GL import *
from OpenGL.GLUT import *
import sta_globals
from ctypes import *
from array import *

#==========================================================================
#															ZipUtils
#==========================================================================
def addFileToArchive(sArchiveName,sFilePath,sFileArchiveName):

	if not os.path.exists(sFilePath):
		return

	if not os.path.exists(sArchiveName):
	  sOpen = "w"
	else:
	  sOpen = "a"

	file = zipfile.ZipFile(sArchiveName, sOpen)
	file.write(sFilePath, sFileArchiveName, zipfile.ZIP_DEFLATED)
	file.close()

def listArchive(sArchiveName):
	lFiles = []
	if os.path.exists(sArchiveName):
		file = zipfile.ZipFile(sArchiveName, 'r')
		lFiles = file.namelist()
		file.close()
	return lFiles

def readFile(sArchiveName,sFileArchiveName):
	lData = ''
	if os.path.exists(sArchiveName):
		file = zipfile.ZipFile(sArchiveName, 'r')
		lData = file.read(sFileArchiveName)
		file.close()
	return lData

#==========================================================================
#															OpenGL patches
#==========================================================================
def my_glutBitmapLength(iFont,sName):
   l_sName = array('B',sName)
   l_p_sName,l_sNameLen = l_sName.buffer_info()
   l_fLen = float(glutBitmapLength(iFont,((c_ubyte * l_sNameLen)(l_p_sName))))
   return l_fLen

def flatten(l):
	l = list(l)
	i = 0
	while i < len(l):
		while (type(l[i]).__name__[:2] == 'c_'):
			l[i:i + 1] = list(l[i])
		i += 1
	return l

#==========================================================================
#																	Arrays
#==========================================================================
def getSelectionIndex(lSelection,lList):
   l_lResult = []
   for i in lSelection:
      try:
         l_iIdx = lList.index(i)
         l_lResult.append(l_iIdx)
      except:
         #print "Index warning: "+str(i)+" is not in list"
         pass
   return l_lResult

#==========================================================================
#																Databases
#==========================================================================

#--------------------------------------------------- Check if DB exists ---
def isValidDB(p_sPath):
   if not os.path.exists(p_sPath):
      return False
   return True

#------------------------------------------------- Check if Table exists ---
def isValidTable(p_cCursorDB,p_sTable):
   sCmd = "select name from sqlite_master where type='table'"
   p_cCursorDB.execute(sCmd)
   for i in p_cCursorDB:
      if p_sTable == i[0]:
         return True
   return False

#----------------------------------------------------- Get available IDs ---
def getCurrentFileDBid():
		l_iResult = 0
		for i in sta_globals.lFiles:
			if i.iDBid > l_iResult:
				l_iResult = i.iDBid
		return (l_iResult+1)

def getCurrentVersionDBid():
		l_iResult = 0
		for i in sta_globals.lFiles:
			for j in i.lRevs:
				if j.iDBid > l_iResult:
					l_iResult = j.iDBid
		return (l_iResult+1)

#==========================================================================
#																	Logging
#==========================================================================

#--- GUI info log ---
def logInfo(p_cFrame,p_sMsg,p_sName='Info'):
    dlg = wx.MessageDialog(p_cFrame, p_sMsg,p_sName,wx.OK | wx.ICON_EXCLAMATION)
    dlg.ShowModal()
    dlg.Destroy()

#--- GUI error log ---
def logError(p_cFrame,p_sMsg,p_sName='Error'):
    dlg = wx.MessageDialog(p_cFrame, p_sMsg,p_sName,wx.OK | wx.ICON_ERROR)
    dlg.ShowModal()
    dlg.Destroy()

#--- Debug print ---1
def dprint(msg):
	sta_globals.fileDebug.write("%s\n"%msg)
	if (sta_globals.bDebug):
		print msg

#==========================================================================
#																	Strings
#==========================================================================

#---------------------------------------- Set special characters to "_" ---


def normalize_c(msg,ch):
    l_msg = ""
    for i in msg:
       if (i in string.digits) or (i in string.letters):
          l_msg = l_msg + i
       else:
          l_msg = l_msg + ch
    return l_msg

def normalize(msg):
    return normalize_c(msg,'_')

#-------------------------------------------- Quote special characters ---
def removeQuotes(msg):
    l_msg = ""
    for i in msg:
       if i == "\"":
          l_msg = l_msg + "\\\""
       else:
          l_msg = l_msg + i
    return l_msg

#--------------------------------------------- Split binary tree input ---
def splitInput(msg):

    # Splits a a tring of the form (a)(b)nr into a,b,nr (doesn't work with simple split)
    if msg.find("(") <0:
       l_sMsg = msg.split()
       return (l_sMsg[0],"",l_sMsg[1])

    i = 0
    pos = 0

    for c in msg:
       pos = pos + 1
       if c == "(":
          i = i+1
       if c == ")":
          i = i -1
       if i == 0:
          break

    str1 = msg[:pos]
    str2 = msg[pos:]
    msg = str2
    pos = 0

    for c in str2:
       pos = pos + 1
       if c == "(":
          i = i+1
       if c == ")":
          i = i -1
       if i == 0:
          break

    str2 = msg[:pos]
    str3 = msg[pos+1:]

    return (str1,str2,str3)

#---------------------------------- Get number of cahracters in a string ---
def getNrCharacters(str,char):
   iNr = 0
   for i in str:
      if i == char:
         iNr = iNr + 1
   return iNr

#-------------------------------- Find the n-th occurence of a substring ---
def xfind(s,sub,idx):
	l_iPos = -1
	for i in range(idx):
		l_iPos = s.find(sub,l_iPos+1)
		if l_iPos<0:
			return l_iPos
	return l_iPos

#------------------------------------ Replace non-ASCI characters with # ---
def ascii(s):
	l_s = ''
	for i in s:
		if ord(i)>127:
			l_s = l_s + '#'
		else:
			l_s = l_s + i
	return l_s

#==========================================================================
#																	Files
#==========================================================================

#-------------------------------------------------- deletes a file tree ---
def del_dir(path):
    for file in os.listdir(path):
       file_or_dir = os.path.join(path,file)
       if os.path.isdir(file_or_dir):
  	  del_dir(file_or_dir) 		# it's a directory reucursive call to function again
       else:
 	  os.remove(file_or_dir) 	# it's a file, delete it
    os.rmdir(path)			# delete the directory itself

#-------------------------------------- count number of lines in a file ---
def count_lines(path):
    iCount = 0
    fileHandle = open(path,"r")
    sLine = fileHandle.readline()
    while (sLine != ""):
    	iCount = iCount+1
    	sLine = fileHandle.readline()
    fileHandle.close()
    return iCount

#-------------------------- Get the recursive list of files in a folder ---
def getFileList(l_sPath):
	for file in os.listdir(l_sPath):
		file_or_dir = os.path.join(l_sPath,file)
		if os.path.isdir(file_or_dir):
			getFileList(file_or_dir)
		else:
			sta_globals.sCMFileList.append(file_or_dir)
#==========================================================================
#																	Time
#==========================================================================
def getDate(iTime):
    l_sDate = "?"
    if (iTime>0):
       l_lDate = time.gmtime(iTime)
       l_sDate = str(l_lDate[0]) + "-"
       if (l_lDate[1]<10):
          l_sDate = l_sDate + "0" + str(l_lDate[1]) + "-"
       else:
          l_sDate = l_sDate + str(l_lDate[1]) + "-"
       if(l_lDate[2]<10):
          l_sDate = l_sDate + "0" + str(l_lDate[2])
       else:
          l_sDate = l_sDate + str(l_lDate[2])
    return l_sDate

def getTime(iTime):
   cTime = time.gmtime(iTime)
   sTime = str(cTime[3])+":"+str(cTime[4])+":"+str(cTime[5])
   return sTime

#==========================================================================
#																	Colors
#==========================================================================
def drawRectangle(ux,uy,lx,ly,size):
    glLineWidth(size)
    glBegin(GL_LINE_LOOP)
    glVertex2f(ux,uy)
    glVertex2f(lx,uy)
    glVertex2f(lx,ly)
    glVertex2f(ux,ly)
    glEnd()
    glLineWidth(1)

#---------------------------------------------------- rainbow color map ---
def getRainbowColor(fIdx):
   dx = 0.8
   if fIdx < 0:
      fIdx = 0
   if fIdx > 1:
      fIdx = 1
   fIdx = (6-2*dx)*fIdx + dx;
   R = max(0.0,(3-math.fabs(fIdx-4)-math.fabs(fIdx-5))/2.0);
   G = max(0.0,(4-math.fabs(fIdx-2)-math.fabs(fIdx-4))/2.0);
   B = max(0.0,(3-math.fabs(fIdx-1)-math.fabs(fIdx-2))/2.0);
   return(R,G,B)

#----------------------------------------------------------- bicolor map ---

def getBiColormap(fValue,p_iIdx):

	l_iIdx = p_iIdx * 3

	(R0,G0,B0) = sta_globals.lBiColorMap[l_iIdx]
	(R1,G1,B1) = sta_globals.lBiColorMap[l_iIdx+1]
	(R2,G2,B2) = sta_globals.lBiColorMap[l_iIdx+2]

	if fValue<0:
		fValue = 0

	if fValue>1:
		fValue=1

	if (fValue<0.5):
		fValue = fValue*2
		R = R0*(1-fValue) + R1*fValue
		G = G0*(1-fValue) + G1*fValue
		B = B0*(1-fValue) + B1*fValue
	else:
		fValue = 2*(fValue-0.5)
		R = R1*(1-fValue) + R2*fValue
		G = G1*(1-fValue) + G2*fValue
		B = B1*(1-fValue) + B2*fValue
	return (R,G,B)

#----------------------------------------------------- activity palette ---
def getActivityColors():
   lPalette = [(1.0, 1.0, 1.0),\
	       (1.0, 1.0, 1.0),\
	       (0.5, 0.5, 1.0),\
	       (0.7, 0.7, 1.0),\
	       (0.9, 0.9, 0.5)]
   return lPalette

#---------------------------------------------- distinct colors palette ---
def getDistinctColors01(iNr):
   lPalette = []
   iRange = int(iNr/2)
   fFactor = float(1) / iNr

   print iRange
   print fFactor

   for i in range(iRange):
      lPalette.append(getRainbowColor(i*fFactor))
      lPalette.append(getRainbowColor(1-i*fFactor))

   return lPalette

def getDistinctColors02():
   lPalette = [(1.00, 0.50, 0.50),\
	(0.00, 1.00, 0.50),\
	(0.50, 1.00, 1.00),\
	(0.00, 0.50, 1.00),\
	(1.00, 0.50, 0.75),\
	(1.00, 0.00, 0.00),\
	(1.00, 1.00, 0.00),\
	(0.50, 1.00, 0.00),\
	(0.00, 1.00, 0.25),\
	(0.00, 0.50, 0.75),\
	(0.50, 0.50, 0.75),\
	(1.00, 0.00, 1.00),\
	(0.50, 0.25, 0.25),\
	(1.00, 0.50, 0.25),\
	(0.00, 1.00, 0.00),\
	(0.00, 0.50, 0.50),\
	(1.00, 0.50, 1.00),\
	(0.00, 0.25, 0.50),\
	(0.50, 0.50, 1.00),\
	(0.50, 0.00, 0.25),\
	(1.00, 0.00, 0.50),\
	(0.00, 1.00, 1.00),\
	(0.50, 0.00, 0.00),\
	(1.00, 0.50, 0.00),\
	(0.00, 0.50, 0.00),\
	(0.00, 0.50, 0.25),\
	(0.00, 0.00, 1.00),\
	(0.50, 1.00, 0.50),\
	(0.00, 0.00, 0.62),\
	(0.50, 0.00, 0.50),\
	(0.50, 0.00, 1.00),\
	(0.25, 0.00, 0.00),\
	(0.50, 0.25, 0.00),\
	(0.00, 0.25, 0.00),\
	(0.00, 0.25, 0.25),\
	(0.00, 0.00, 0.50),\
	(0.00, 0.00, 0.25),\
	(0.25, 0.00, 0.25),\
	(0.25, 0.00, 0.50),\
	(0.00, 0.00, 0.00),\
	(1.00, 1.00, 0.50),\
	(0.50, 0.50, 0.00),\
	(0.50, 0.50, 0.25),\
	(0.50, 0.50, 0.50),\
	(0.25, 0.50, 0.50),\
	(0.75, 0.75, 0.75),\
	(1.00, 1.00, 1.00)]
   return lPalette

#==========================================================================
#																	Fonts
#==========================================================================
def renderBitmapString(x,y,font,sText,mode):
# mode = 0 -> Left aligned
# mode = 1 -> Center aligned
# mode = 2 -> Right aligned

  iLen = my_glutBitmapLength(font,sText)

  if mode == 1:
     glRasterPos2f(x-iLen/2, y)
  elif mode == 2:
     glRasterPos2f(x-iLen, y)
  else:
     glRasterPos2f(x, y)


  for c in sText:
    glutBitmapCharacter(font, ord(c))

#==========================================================================
#																	Shapes
#==========================================================================

#---------------------------------------------------------- Draw circle ---
def drawCircle(pos,radius,size):

   glLineWidth(size)
   num_lines = 35

   glBegin(GL_LINE_LOOP)
   for i in range(num_lines):
   	angle = i*2*math.pi/num_lines
   	glVertex2f(pos[0]+math.cos(angle)*radius,pos[1]+math.sin(angle)*radius)
   glEnd()

   glLineWidth(1)

#------------------------------------------------------- Draw rectangle ---
def drawRectangle(ux,uy,lx,ly,size):
   glLineWidth(size)
   glBegin(GL_LINE_LOOP)
   glVertex2f(ux,uy)
   glVertex2f(lx,uy)
   glVertex2f(lx,ly)
   glVertex2f(ux,ly)
   glEnd()
   glLineWidth(1)

#------------------------------------------- Draw disk in isomorph space ---
def drawDisk(pos,radius):
   num_lines = 35

   glBegin(GL_POLYGON)
   for i in range(num_lines):
   	angle = i*2*math.pi/num_lines
   	glVertex2f(pos[0]+math.cos(angle)*radius,pos[1]+math.sin(angle)*radius)
   glEnd()

#---------------------------------------- Draw disk in nonisomorph space ---
def drawNDisk(pos,radius):
   num_lines = 10

   glBegin(GL_POLYGON)
   for i in range(num_lines):
   	angle = i*2*math.pi/num_lines
   	glVertex2f(pos[0]+math.cos(angle)*radius[0],pos[1]+math.sin(angle)*radius[1])
   glEnd()

