﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SolidTA.TFSImporter.Collections
{
    public class TwoKeyDictionary<K1, K2, V>
    {
        private readonly Dictionary<Pair, V> map = new Dictionary<Pair, V>();

        public Dictionary<Pair, V> Map
        {
            get { return map; }
        }

        public V this[K1 k1, K2 k2]
        {
            get { return map[new Pair(k1, k2)]; }
            set { map[new Pair(k1, k2)] = value; }
        }

        public bool ContainsKey(K1 k1, K2 k2)
        {
            return map.ContainsKey(new Pair(k1, k2));
        }

        public int Count
        {
            get { return map.Count; }
        }

        public Dictionary<Pair, V>.Enumerator GetEnumerator()
        {
            return map.GetEnumerator();
        }

        public struct Pair
        {
            public K1 First;
            public K2 Second;

            public Pair(K1 k1, K2 k2)
            {
                First = k1;
                Second = k2;
            }

            public override Int32 GetHashCode()
            {
                return First.GetHashCode() ^ Second.GetHashCode();
            }
        }
    }
}
