﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.TFSImporter.Models.Deps
{
    [Table("D_TFS_Deps_Files")]
    class File
    {
        [PrimaryKey, AutoIncrement]
        public int ID { get; set; }

        [ForeignKey(typeof(Models.File), OnDelete = "cascade")]
        public int? TFSFile { get; set; }

        [ForeignKey(typeof(Solution), OnDelete = "cascade"), Indexed]
        public int Solution { get; set; }

        [ForeignKey(typeof(Project), OnDelete = "cascade"), Indexed]
        public int Project { get; set; }

        [Text, Indexed]
        public string Path { get; set; }
    }
}
