﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.TFSImporter.Models.Deps
{
    [Table("D_TFS_Deps_MethodMetrics")]
    class MethodMetric
    {
        /// <summary>
        /// Primary key
        /// </summary>
        [PrimaryKey, AutoIncrement]
        public int ID { get; set; }

        /// <summary>
        /// Version ID to which this metric applies
        /// </summary>
        public int Version { get; set; }

        /// <summary>
        /// Fully Qualified method name
        /// </summary>
        [Text]
        public string Method { get; set; }

        /// <summary>
        /// Fan-in
        /// </summary>
        public int FI { get; set; }

        /// <summary>
        /// Fan-out
        /// </summary>
        public int FO { get; set; }

        /// <summary>
        /// Cohesion
        /// </summary>
        public float Cohesion { get; set; }
    }
}
