﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.TFSImporter.Models.Deps
{
    [Table("D_TFS_Deps_Relations")]
    class Relation
    {
        public enum Types
        {
            // Call relation
            Call = 0,

            // Constructur call
            Construct = 1,

            // Property access
            Access = 2,

            // Class inherit relation
            Inherits = 3,

            // Class implements relation
            Implements = 4,

            // Field type relation
            IsA = 5,
        }

        [PrimaryKey, AutoIncrement]
        public int ID { get; set; }

        public int Revision { get; set; }

        public int Delta { get; set; }

        public int Count { get; set; }

        [ForeignKey(typeof(Member), OnDelete = "cascade")]
        public int Caller { get; set; }

        [ForeignKey(typeof(Member), OnDelete = "cascade")]
        public int Callee { get; set; }

        public Types Type { get; set; }

        // Marker that specified the solution this edge applies to.
        // Not strictly necessary since this may be queried from the file
        // relation of the caller, however storing it inline is much simpler.
        [ForeignKey(typeof(Solution), OnDelete = "cascade")]
        public int Solution { get; set; }

        [ForeignKey(typeof(Project), OnDelete = "cascade")]
        public int Project { get; set; }

        // Determines if this relation has been "touched" for the changeset
        public bool Touched = true;
    }
}
