﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SQLite;

namespace SolidTA.TFSImporter.Models.Deps
{
    [Table("D_TFS_Deps_VersionedMethods")]
    class VersionedMethod
    {
        /// <summary>
        /// Version ID of the file
        /// </summary>
        [ForeignKey(typeof(Models.Version), OnDelete = "cascade")]
        public int ID { get; set; }

        /// <summary>
        /// Fan-in
        /// </summary>
        public int FI { get; set; }

        /// <summary>
        /// Fan-out
        /// </summary>
        public int FO { get; set; }

        /// <summary>
        /// Cohesion
        /// </summary>
        public float Cohesion { get; set; }
    }
}
